.;----------------------------------------------------------------------------
.;
.; CMD Program:	B R U M T D
.;
.; Author:	Klaas H.N. Bos
.;
.; Date:	Summer 1981
.;
.; Version:	1.17	4-Dec-86
.;
.; Note:	Don't forget to update the BIOREGAN Manual.
.;
.; Modified by:	Jan H. Belgraver	27-JAN-83	JB02	V1.2
.; 		BRU command file is created in directory LB:[20,1].
.; 		This is in case the directory involved does not exist
.; 		on SY:. [20,1] has been chosen since it has also 
.; 		RWED-access for World.
.;
.; 		Jan H. Belgraver	23-FEB-83	JB03	V1.4
.; 		Empty strings are not alowed.
.;
.; 		Jan H. Belgraver	28-FEB-83	JB04	V1.5
.; 		For compatibility with DCL.
.;
.; 		Jan H. Belgraver	1-NOV-83	JB05	V1.6
.; 		Modified question layout, added string range or 
.; 		default value to question and added syntax check on 
.; 		input device name.
.;
.; 		Jan H. Belgraver	11-NOV-83	JB06	V1.7
.; 		Stringrange limits should be decimal.
.;
.; 		Jan H. Belgraver	8-DEC-83	JB07	V1.8
.; 		MOU qualifier removed since DM1: is public device.
.;
.; 		Jan H. Belgraver	30-NOV-84	JB08	V1.9
.; 		1. Reset terminal properly if ^Z entered.
.; 		2. No lowercase allowed on certain questions.
.; 		3. Prepare commandfile on SY:.
.; 		4. Print current UIC and new warning.
.; 		5. Have BRU create UFD if it does not exist.
.; 		6. Bell now rings once per 10 sec.
.;
.; 		Jan H. Belgraver	4-JAN-85	JB09	1.10
.; 		1. Filename input as in DMTOMM.CMD
.; 		2. Default is now copying all files.
.; 		3. Force new version if not superseding mode.
.;
.; 		Jan H. Belgraver	12-FEB-85	JB10	V1.11
.; 		1. Fixed directory problem
.; 		2. Enabled continuation lines
.; 		3. Made "Display files copied" optional
.;
.; 		Jan H. Belgraver	11-MAR-85	JB11	V1.12
.; 		Allocate MM:
.;
.; 		Jan H. Belgraver	20-MAR-85	JB12	V1.13
.; 		BRU cmd-line should contain 'DIS' since V1.11.
.;
.; 		Jan H. Belgraver	27-MAR-85	JB13	V1.14
.; 		No new version if not superseding.
.;
.;		Jan H. Belgraver	20-NOV-85	JB14	V1.15
.;		Renamed from MMTODM into BRUMTD.
.;
.;		Jan H. Belgraver	22-JAN-86	JB15	V1.16
.;		Add check for our 'new' RP06
.;
.;		Jan H. Belgraver	4-Dec-86	JB16	V1.17
.;		1. Create terminal-related BRU command file in LB:[20,20] 
.;		since that directory has write access for world.
.;		2. Added option for New_version or Supersede in case of
.;		version number clash.
.;----------------------------------------------------------------------------

.enable	substitution
.enable	decimal								! JB06
.enable	control-z							! JB08
.disable lowercase							! JB08
.;
.ifnins	BRU	INS $BRU
.sets	DIS	""							! JB10
.sets	SUP	""
.sets	NEW	""							! JB13
.sets	INDEV	"MM:"							! JB10
.enable	quiet								! JB03
	.setf	DCL							! JB03
	.if	<CLI> eq "DCL"	.sett	DCL				! JB03
.;	If current CLI is DCL reset to MCR				! JB03
	.ift	DCL	SET TERMINAL/MCR
	ALL	MM:			! Make it private		  JB12
.disable	quiet							! JB03
.disable display							! JB08
;
;	Copying files from BRU-TAPE to DISK
;
;		W A R N I N G
;
;	Input and output UICs must match
;	Current UIC = '<UIC>'
;
	.enable	display							! JB08
	.ask [<TRUE>]	OK	Continue
	.ift	<EOF>	.goto	FINISH					! JB08
	.iff	OK	.goto	FINISH					! JB08
.;
.;	Get terminal specs						! JB16
	.testdevice TI:							! JB16
	.parse	<EXSTRI> ","	TIDEV	REST				! JB16
	.test	TIDEV		! Get string-length			| JB16
	.sets	TIDEV	TIDEV[2:<STRLEN>-1]	! Remove : and 1st T	| JB16
	.disable display						! JB08
;
	.enable	display							! JB08
	.enable lowercase						! JB08
	.asks	[1:12]	BCS	Bacupset name		
	.ift	<EOF>	.goto	FINISH					! JB08
.DEVICE:
	.disable lowercase						! JB08
	.asks	[1:4]	OUTDEV	To DB:, DM:, or DM1:	
	.ift	<EOF>	.goto	FINISH					! JB08
	.sets	S	OUTDEV[1:2]					! JB06
	.if	S eq "DB"	.goto	DEV5				! JB15
	.if	S eq "DM"	.goto	DEV5				! JB15
	.goto	DEVICE							! JB15

.DEV5:	.sets	S	OUTDEV[<STRLEN>:<STRLEN>]			.;JB06
	.if	S ne ":"	.goto	DEVICE				! JB06
.SPRS:
	.disable display						! JB15
;
;	When restoring your file(s) a confict may arise if 
;	on both output and input device 
;	one or more filespecifications (i.e. name+type+version) are equal.
;	It can be solved in two ways:
;
;	1) If you take NEW_VERSION the conflict is solved by forcing
;	   a one-higher version number.
;
;	2) If you use SUPERSEDE the conflict is solved by overwriting, but
;	  that does NOT guarantee that the file has the highest version number
;	  if more of them are present.
;
;	The default action is NO_SUPERSEDE, i.e. file is not copied.
;
	.enable display							! JB15
	.asks 	SPS	New_Version <NEW>, or Superseding <SUP>	
	.ift	<EOF>	.goto	FINISH					! JB08
	.if	<STRLEN> eq 0	.goto	LIST				! JB15
	.if	SPS eq "SUP"	.sets	SUP	"/SUP"			! JB15
	.if	SPS eq "NEW"	.sets	NEW	"/NEW"			! JB15
.;
.LIST:									.;JB15
	.ask	[<TRUE>]	FILLST	Copied files listing	
	.ift	<EOF>	.goto	FINISH					! JB10
	.ift	FILLST	.sets	DIS	"/DIS"				! JB10
.FILNAM:								.;JB09
	.disable display						! JB15
	;	Filename(s) [<cr> = all files]
	;	            [Add ,- for continuation line]
	.enable display							! JB15
	.setn	N	0						! JB10
.GETFIL:								.;JB10
	.inc	N							! JB10
	.asks	[0:60] TEMP
	.ift	<EOF>	.goto	FINISH					! JB08
.;	.if	<STRLEN> eq 0	.sets	FLN	"*.*"			! JB09
	.if	N gt 1	.goto	10					! JB10
	.parse	TEMP	"]"	DIR FLN					! JB10
	.test	FLN							! JB10
	.if	<STRLEN> eq 0	.sets	FLN	DIR			! JB10
	.if	<STRLEN> eq 0	.sets	TEMP	<UIC>+FLN		! JB10
	.sets	TEMP	INDEV+TEMP					! JB10
.10:	.sets	LINE'N'	TEMP						.;JB10
	.test	TEMP
	.sets	TEMP	TEMP[<STRLEN>-1:<STRLEN>]			! JB10
	.if	TEMP ne ",-"	.goto	BLDCMD				! JB10
	.sets	INDEV	""						! JB10
	.goto	GETFIL							! JB10
.BLDCMD:
	.disable display						! JB15
;
;			* Working *
	.enable display							! JB15
	.open	LB:[20,20]BRUMTD'TIDEV'.CMD;1				! JB16
	.data /REW'DIS'/NOINI/UFD'SUP''NEW'/BAC:'BCS'
	.setn	NTOT	N
	.setn	N	0
.BLDSTR:								.;JB10
	.inc	N							! JB10
	.sets	TEMP	LINE'N'						! JB10
	.data 'TEMP'
	.if	N lt NTOT	.goto	BLDSTR				! JB10
	.data 'OUTDEV'
	.close
.;
	.enable	quiet							! JB08
	PIP	TI:=LB:[20,20]BRUMTD'TIDEV'.CMD;1			! JB16
	BRU	@LB:[20,20]BRUMTD'TIDEV'				! JB16
	RUN	$REWIND/TASK=REWIND
	BEL 0
	PIP	LB:[20,20]BRUMTD'TIDEV'.CMD;1/DE			! JB16
.FINISH:
	.disable display						! JB08
	.enable	quiet							! JB08
	DEA	MM:		! Make it available for other users	  JB12
	.;	If user CLI was DCL reset terminal.			! JB01
	.ift	DCL	SET /DCL=TI:
.EXIT

