.;
.;----------------------------------------------------------------------------
.;
.; CMD-file:	C H K D A T E 
.;
.; Author:	Jan H. Belgraver
.;
.; Date:	25-JUL-84
.;
.; Version:	1.4	24-FEB-86
.;
.; Purpose:	Checks date string syntax.
.;
.; Call:	@CHKDATE Date
.;
.; Arguments:	Name	I/O	Type	Description
.;		P1	 I	String	Date to be checked on input.
.;		$DATE	I/O	String	Date to be checked on input,
.;					possibly corrected date on output.
.;
.; Description:	If the date parameter is not present it is asked for.
.;		Also, if a syntax error is discovered the question is
.;		put again.
.;		In case the string has changed, it is returned to the
.;		calling command file via global symbol $DATE.	
.;
.; Modified by:	Jan H. Belgraver	13-FEB-85	JB01	V1.1
.;		Spelling error correction
.;
.;		Jan H. Belgraver	5-SEP-85	JB02	V1.2
.;		1. Enable decimal and disable lowercase
.;		2. Date should be re-assembled after correction.
.;
.;		Jan H. Belgraver	15-NOV-85	JB03	V1.3
.;		Name changed from DATECHECK into CHKDATE.
.;
.;		Jan H. Belgraver	24-FEB-86	JB04	V1.4
.;		Replaced erroneous 'return' with 'exit'.
.;----------------------------------------------------------------------------
.;

.enable substitution
.enable	global
.enable	decimal								.;JB02
.disable lowercase							.;JB02
.;
.sets	$DATE	P1
.test	$DATE
.if	<STRLEN> NE 0	.goto	CHECK
.ASKDAT:
;
	.asks [8.:9.]	$DATE	Re-enter date	
.CHECK:	.GOSUB	DATCHK
	.ift	DATERR	.goto	ASKDAT
.exit
.;
.;----------------------------------------------------------------------------
.;
.DATCHK:
.;	Syntax check on date string
.;
.setf	DATERR
.sets	AZUTBL	"ABCDEFGHIJKLMNOPQRSTUVWXYZ"
.sets	AZLTBL	"abcdefghijklmnopqrstuvwxyz"
.sets	MONUTB	"JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC"
.sets	MONLTB	"janfebmaraprmayjunjulaugsepoctnovdec"
.;
.parse	$DATE	"-"	DAY MONTH YEAR
.parse	<DATE>	"-"	CDAY CMONTH CYEAR
.test	AZUTBL	DAY
.if	<STRLEN> NE 0	.goto	DERR
.test	AZLTBL	DAY
.if	<STRLEN> NE 0	.goto	DERR
.test	DAY
.if	<STRLEN> LT 1	.or	.IF <STRLEN> GT 2	.goto DERR
.if	<STRLEN> EQ 1	.SETS	DAY	"0"+DAY
.if	DAY LT "01"	.or	.IF DAY GT "31"	.goto	DERR
.;
.test	MONTH
.if	<STRLEN> LT 1	.or	.IF <STRLEN> GT 3	.goto MERR
.test	MONUTB	MONTH
.if	<STRLEN> EQ 0	.goto	MERR
.test	MONLTB	MONTH
.if	<STRLEN> EQ 0	.goto	MERR
.;
.test	YEAR
.if	<STRLEN> NE 2	.goto YERR
.if	YEAR EQ CYEAR	.goto	20
;
.ask [<FALSE>]	OK	Year is '''YEAR''' are you sure
.iff	OK	.goto	15
	.goto	20
.DERR:
;
; * W * -- Date syntax error
	.goto	10
.MERR:
;
; * W * -- Month syntax error
	.goto	10
.YERR:
;
; * W * -- Year syntax error
.10:
;
; in string '$DATE'
.15:	.sett	DATERR
.20:
	.enable lowercase						.;JB02
	.sets	$DATE	DAY+"-"+MONTH+"-"+YEAR				.;JB02
.;	'$DATE'
	.exit								! JB04
