.;
.;----------------------------------------------------------------------------
.;
.; CMD-file:	L B L B R U
.;
.; Author:	Jan H. Belgraver
.;
.; Date:	12-SEP-85
.;
.; Version:	V1.2	9-Feb-89
.;
.; Description:	1. Generates as set of escape sequences for setting LA120 in
.;		file LBLBRU.SEC.
.;		2. Generates text for four parallel labels in LBLBRU.TXT plus
.;		additional escape sequences to make the formlength 1,5 inch.
.;		3. Following transmission of LBLBRU.ESC to the LA120 execution
.;		is suspended to enable the user to load the pinfeed labels.
.;		After asking for the number of four-label series printing 
.;		is started. 
.;		LBLBRU.SEC contains the following escape sequences:
.;			esc[2w		12 char./inch
.;			esc[1;158s	Left resp. Right margin
.;			esc[1z		6 lines/inch
.;			esc[9t		Formlength = 3 lines
.;			esc[2g		Clear all hor. tabs
.;			esc[1;38;78;118uTab stops	for LA100
.;			esc[1;36;76;116uTab stops	for LA120
.;
.; Calls to:	ALL, PIP
.;
.; Modified by:	Jan H. Belgraver	17-Jul-87	JB01	V1.1
.;		1. Removed ALL, since with V4.2-D an "ALL -- Device busy" 
.;		   error message is returned.
.;		2. Added message to stop printer queue.
.;
.;		Jan H. Belgraver	9-Feb-89	JB02	V1.2
.;		For use of LA100
.;----------------------------------------------------------------------------
.;

.enable	substitution
.enable	decimal
.sets	ESC	""
;
;	Printing label:	RSX BRU-tapes
;
	.enable	quiet
.;	ALL	TT4:							! JB01
.;	.if	<EXSTAT> NE 1	.goto	FINISH				! JB01
	.disable quiet
;
	WARNING -- Before continuing ask System Manager to stop Queue TT4:
;
	.ask [<false>]	INIT	Printer setting already done
	.ift	INIT	.goto	DOIT
	.enable quiet
.;
	.open 	LBLBRU.ESC
	.data 'ESC'[2w
	.data 'ESC'[1;158s
	.data 'ESC'[1z
	.data 'ESC'[9t
	.data 'ESC'[2g
	.data 'ESC'[1;38;78;118u
.close 
.;
	PIP	TT4:=LBLBRU.ESC
	.disable	quiet
	.if	<EXSTAT> NE 1	.goto	FINISH
;
;	Pausing to load pin-feed paper on LA120.
;
;	Left Margin:	  |
;			  O     ^---^ <-- Top of printer head
;			  |_____|   |____ Line Indicator
;			 /| 
;			/ |<------------- Angle-line off Line Indicator
;			| |
;			| O <------------ Pin-feed hole
;
.;	Top of labels	= Level with Line Indicator	for LA120
;	Top of labels	= 1. bottom of previous label level with 
;			  top of printer head, next
;			  2. one knob-click to top-of-form 
.pause
.DOIT:
	.open 	LBLBRU.TXT
	.data Volume label  :	Volume label  :	Volume label  :	Volume label  :
	.data Backup_set(s) :	Backup_set(s) :	Backup_set(s) :	Backup_set(s) :
	.data               :	              :	              :	              :
	.data               :	              :	              :	              :
	.data               :	              :	              :	              :
	.data 800 / 1600 / TK	800 / 1600 / TK	800 / 1600 / TK	800 / 1600 / TK
	.data Owner [       ]	Owner [       ]	Owner [       ]	Owner [       ]
	.data Creation date :	Creation date :	Creation date :	Creation date :
.;	.data Density       :	Density       :	Density       :	Density       :
	.data 
	.close 
.;
	.askn [::1]	NUM	How many rows
	.setn	N	0
	.enable	quiet
.LOOP:	.inc	N
	.if	N > NUM	.GOTO	FINISH
	PIP	TT4:=LBLBRU.TXT
	.goto	LOOP
.;
.FINISH:
	.disable display
	PIP	LBLBRU.ESC;*/DE/NM,.TXT;*
.EXIT
