.;----------------------------------------------------------------------------
.;
.; CMD-file:	I N C B A C K U P
.;
.; Author:	Jan H. Belgraver
.;
.; Date:	24-JUL-84
.;
.; Version:	1.8	25-Oct-88
.;
.; Purpose:	Performing incremental disk backups using BRU.
.;
.; Call:	@[5,104]BIOREGAN/LB:INCBACKUP [P1] [P2]
.;
.; Arguments:	Name		Description
.;		P1	Optional input device	Local  symbol	INDEV
.;		P2	Optional Start date	Global symbol	$DATE
.;
.; Calls to:	BIOREGAN.CLB/LB:CHKDATE
.;
.; Description:	If Input device and/or File revision date are not
.;		given they are asked for here.
.;		The date syntax is checked via a call to DATECHECK.CMD
.;
.; Modified by:	Jan H. Belgraver	17-JUN-85	JB01	V1.1
.;		1. Backup-set name should start with AF:, not AFT:.
.;		2. Info-text from SYSBACKUP.CMD to this file.
.;
.;		Jan H. Belgraver	5-SEP-85	JB02	V1.2
.;		1. Disable use of DM0:.
.;		2. Get DATECHECK.CMD always from [5,104]
.;
.;		Jan H. Belgraver	3-MAR-86	JB03	V1.3
.;		Perform date-check via routine in BIOREGAN.CLB
.;
.;		Jan H. Belgraver	17-Sep-86	JB04	V1.4
.;		Enable incremental backup of DB:
.;
.;		Jan H. Belgraver	28-NOV-86	JB05	V1.5
.;		1. Disable quiet in startup
.;		2. Added missing rewind tape
.;		3. Runs from BIOREGAN.CLB only.
.;
.;		Jan H. Belgraver	30-NOV-87	JB06	V1.6
.;		1. Added EXCLUDE option
.;		2. Added Output Volume Label option
.;		3. Allow lowercase device names.
.;		4. Backupset directory listing option
.;
.;		Jan H. Belgraver	7-Dec-87	JB07	V1.7
.;		Do 1st form-feed on LA120 and spawn tape rewind before
.;		asking BRU backupset directory listing.
.;
.;		Jan H. Belgraver	25-Oct-88	JB08	V1.8
.;		1. Enable use of virtual disks.
.;		2. Device check now done in subroutine DEVTST.
.;		3. Backup-set directory listing now default.
.;----------------------------------------------------------------------------
.;
.;

.enable substitution
.enable	global
.IFNINS	BRU	INS $BRU
.sets	OUTNAM	""		! Default output volume label		| JB06
.sets	EXDAT	""		! Default no files to be excluded	| JB06
.sets	EXC	""		! Default = no EXCLUDE qualifier	| JB06
.disable quiet								! JB05
.disable lowercase							! JB08
;
;	Procedure to make an incremental full disk backup to tape.
;
;	Note that the input disk will be dismounted.
;
;	It is expected that 
;
;	A. The input disk is:
;		1. A system disk, or other whole disk to be backed-up
;		2. Present on DM1:, DM2: DB0:, or VEn:
;
;	B. The output tape already contains a BRU backupset.
;
.ask [<FALSE>]	MODE	Are you shure
.iff	MODE	.PAUSE			
	.sets	INDEV	P1						! JB08
	.test	INDEV
	.if	<STRLEN> gt 0	.goto	DEV5
;
.DEV1:	.asks [4:4]	INDEV	From DB0:, DM1:, DM2:, or VEn:	
.DEV5:	.gosub	DEVTST		! Check syntax and if valid device	| JB08
	.ift	ILLDEV	.goto	DEV1					! JB08
.;
.TSTP2:
	.TEST	P2
	.IF	<STRLEN> GT 0	.GOTO	DAT5
;
.DAT1:	.ASKS [8.:9.]	$DATE	Previous incr. backup date	
	.GOTO	DAT6
.DAT5:	.SETS	$DATE	P2
.DAT6:	@/LB:CHKDATE '$DATE'						! JB05
.;
.VOLBL:									! JB06
	.asks [0:12]	OUTNAM	Enter Volume Label		
	.if	<STRLEN> eq 0	.goto	EXCL				! JB06
	.sets	OUTNAM	"/OUT:"+OUTNAM					! JB06
.EXCL:
	.ask [<FALSE>]	EXCLD	Exclude any files or directory	
	.iff	EXCLD	.goto	BUPDIR					! JB06
	.asks [5:55]	EXDAT	Enter details	
	.sets	EXC	"/EXCLUDE"					! JB06
.BUPDIR:
	.ask [<TRUE>]	LIST	Backup_Set directory listing	
.;
.CRECMD:
	.OPEN	#1 INCBUP.CMD;1234
	.DATA	#1 /APP/REW/VER/DEN:1600'EXC'-
	.data	#1 'OUTNAM'/BAC:AF:'$DATE'/REV:AFT:'$DATE'
	.DATA	#1 'INDEV''EXDAT'
	.DATA	#1 MM:
	.CLOSE	#1
	PIP	TI:=INCBUP.CMD;1234
	DMO	'INDEV'/DEV						! JB04
	BRU	@INCBUP.CMD
	PIP	INCBUP.CMD;1234/DE
.;
	.iff	LIST	.goto	FINISH					! JB06
		LAS PA			! Force form-feed		| JB07
	.xqt	RUN $REWIND/TASK=REWIND					! JB07
		BRU /REW/DIR/BAC:AF:'$DATE' MM:				! JB06
.FINISH:
	.EXIT

.;----------------------------------------------------------------------------
.;
.; Subroutine:	D E V T S T
.; Purpose:	Checks device syntax and validity
.; Author:	Jan H. Belgraver
.; Date:	25-Oct-88
.; Version:	V1.0	25-Oct-88
.; Modified by:	
.;----------------------------------------------------------------------------
.;
.DEVTST:
	.enable 	substitution
	.enable		quiet
	.disable	lowercase
	.sett		ILLDEV
	.sets	DRVTBL	"DM1DM2DB0VE0VE1VE2VE3"

	.setn	P	1	
	.setn	N	0	.; Device counter			
.LOOP:				
	.inc	N							
	.setn	P	P+3	
	.if	P gt 22.	.return
	.sets	DEV	DRVTBL['P'-3:'P'-1]+":"
	.sets	TMP	INDEV[4:4]
	.if	TMP ne ":"	.goto	LP10
	.sets	TMP	INDEV[3:3]
	.if	TMP ne ":"	.goto	LP5
	.sets	INDEV	INDEV+"0:"
.LP5:	.if	INDEV ne DEV	.goto	LOOP
	.setf	ILLDEV
.LP10:
	.return
