.;
.;----------------------------------------------------------------------------
.;
.; CMD-File:	D E V A T T T S T
.;
.; Purpose:	Cecks if device is attached, e.g. testing of printer status 
.;		to find out if despooler task is busy or not.
.;
.; Author:	Jan H. Belgraver
.;
.; Date:	1-JUL-85
.;
.; Version:	V1.0
.;
.; Call:	DEVATTTST P1
.;
.; Parameters:	Name	I/O	Type	Description
.;		P1	 I	String	Device name, e.g. TT4:
.;		$ATACH	 O	Logical	Error/Success status
.;					False	Not attached
.;					True	Device attached.
.;		<EXSTAT>	Numeral	Error/Success status
.;					0	Device attached
.;					1	Not attached
.; Calls to:	
.;
.; Description:	<EXSTRI> is filled following an .TESTDEVICE directive.
.;		It contains the four device-characteristics words:
.;		U.CW1, U.CW2, U.CW3, resp. U.CW4 and one or more 
.;		device atttributes.
.;		If despooler task is busy status is ATT (attached), otherwise
.;		one of the device attributes contains NAT (not attached).
.;
.; Modified by:	Jan H. Belgraver	22-NOV-85	JB01	V1.1
.;		Return status via <EXSTAT> facility.
.;
.;----------------------------------------------------------------------------
.;
.;

.enable		substitution
.disable	lowercase
.enable		global
.enable		quiet					
.setn	N	0
.setf	$ATACHD
.setn	STATUS	1		! Preset to not-attached		! JB01

	.testdevice	'P1'
	.sets	TMP	<EXSTRI>
	.parse	TMP	"," DEV CW1 CW2 CW3 CW4 DEVATR
	.PARSE	DEVATR	"," D1 D2 D3 D4 D5 D6 D7 D8 D9 D10 D11 D12 D13 D14 D15

.LOOP:
	.inc	N
	.if	N GT 15		.goto	RETURN
	.if D'N' NE "ATT"	.goto	LOOP
	.sett	$ATACH
	.setn	STATUS	0	! Attached				! JB04
.RETURN:
	.exit	'STATUS'						! JB01
