{$DOUBLE}

Program MSLoop;

{
  Description: General Message Looper
         File: [message]MSLoop.PAS
       Author: Jim Bostwick  23-NOV-1988 
    Last Edit: 9-APR-1990 22:35:52 
      History:
	 9-APR-1990 - JMB - clean up comments, remove deadwood
	 14-DEC-1989  JMB - add logical for logfile, use MSRPLY
    	 20-OCT-1989  JMB - modified header, integrated message_rec
    	 9-OCT-1989 - JMB - major happy munging...
	 3-AUG-1989 - JMB - Add $DOUBLE compiler switch


*USER*

This is a simple test program to loop messages back on themselves. It is 
intended for use with text-based message bodies only, and doesn't check for 
the content! As it is unlikely to be of much use with code-based messages
anyway, the effort to crack the message type, subtype, etc. has not been made. 

Normal usage is with packet type 39 (comment). 

*WIZARD* 

}

{$nolist}
{[a+,b+,l-,k+,r+] Pasmat }
%INCLUDE 'PAS$EXT:GENERAL.TYP';
%INCLUDE 'PAS$EXT:MESSAGE.pkg';
%INCLUDE 'PAS$EXT:STRING.PKG';
%INCLUDE 'Pas$ext:GTSK.TYP';
%INCLUDE 'Pas$ext:GTSK.Ext';
%INCLUDE 'PAS$EXT:CATR56.EXT';
%INCLUDE 'PAS$EXT:CR56TA.EXT';
%include 'pas$ext:tlon.ext';
%include 'pas$ext:rdef.ext';
%include 'pas$ext:clef.ext';
%include 'pas$ext:stlo.ext';
%include 'pas$ext:srda.ext';
{$list}


CONST
	die_efn = f92;
	rcv_efn = f93;
var
	In_Msg: Message_rec;
	istat, Stat, Len, pos: integer;
	done: boolean;
	r5nam:Rad56;
	Tsk_info: Task_info_rec;
	MyName: CH6;  		{ name we're running under }
	LogFlag: CH8; 		{ flag string for logging }
	Lognam: CH20;		{ log file name }
	Loglen: Integer; 	{ length of logfile name }
	temp_node, node: CH6;   { node we're running on }
	Str,out_str: ch80;    	{ useful strings }


{ Procedure to dump DSW and header }
Procedure Dump_hdr(Var h:Message_Rec);

VAR
	nam: CH6;
BEGIN
	swrite(output,LogFlag);
	writeln(output,'MSLOOP> Dump of Message Header:');
	writeln(output,'And the status is ',$DSW,'.');
        dmphdr(output,h)
end;



BEGIN  { Main }
	done := false;
	clef(die_efn);
	clef(rcv_efn);
	srda(rcv_efn);	{ Arm Receive_data AST }
	Gtsk(tsk_Info);		     { find out about self }
	cr56ta(Tsk_info.Name,MyName);  { make it printable }
	sassign(LogFlag,MyName);	{ build log flag string }
	sconcat(LogFlag,'> ');
	Tlon('SYS$NODE',node,len);	{ find out node name }
	sassign(str,'MSLoop operating on ');	{ Build welcome message }
	sconcat(str,node);
	sconcat(str,' as task ');
	sconcat(str,Myname);
	schconcat(str,'.');
   
{ Check for log file request. If logical doesn't translate, just log to NL: }
	Tlon('MSLOOP$LOG_FILE',lognam,loglen);	
	if loglen = 0 
	    THEN Rewrite(output, 'NL:')
	    ELSE Rewrite(output,Lognam);
	swrite(output,str);
	writeln;

{ 
    Do our simple-minded thing. Receive messages, send them back whence they 
    came. 
}

	repeat
	    SClear(In_Msg.comment);	{ clear out old junk }
	    stlo([rcv_efn,die_efn]);	{ wait for activity }
	    if rdef(rcv_efn) then 
    		REPEAT
		clef(rcv_efn);
		MSRcv(null_task_name,In_Msg);
		istat := $dsw;
		If $dsw > 0 THEN 
		    BEGIN
		    Dump_Hdr(In_Msg);
		    Writeln('  and the text is:');

		    { Break message text up into readable chunks. }
		    len := slen(In_msg.comment);
		    pos := 1;
		    While len >= 70 do 
			begin
			writeln('len=',len,'   pos=',pos);
			ssubstr(str,in_msg.comment,pos,70);
			sassign(out_str,LogFlag);
			sconcat(out_str,str);
			sconcat(out_str,'| ');
			swrite(output,out_str);
			writeln(output);
			pos := pos + 70;
			len := len - 70
			end;
		    if (len > 0) then 
			begin
			writeln('len=',len,'   pos=',pos);
			ssubstr(str,in_msg.comment,pos,len);
			sassign(out_str,LogFlag);
			sconcat(out_str,str);
			sconcat(out_str,'| ');
			swrite(output,out_str);
			writeln(output)
			end;
    	
		    msrply(in_msg,f0);
		    Swrite(output,LogFlag);
		    Writeln('MSLOOP> Reply status = ',$dsw,'.')
		    end;
		UNTIL (istat <= 0);
	    done := rdef(die_efn)
	until done;	
	writeln( 'Task ',Myname,' done.')
end.
    
 
