{$DOUBLE}
Program signal;
 {$nomain}

{ 
       Desc: Message (a`la LIB$SIGNAL) procedure for AMIRTR
       File:[AMIRTR]signal.PAS
     Author: Jim Bostwick  6-DEC-1988 
  Last Edit: 6-DEC-1989 00:41:20 
    History:
         26-OCT-1989 -JMB - add debug stuff
         3-AUG-1989 - JMB - Add $DOUBLE compiler switch


}
 {$Nolist}
 {[a+,b+,l-,k+,r+] Pasmat }
 %INCLUDE 'AMIRTR.PKG';
 %INCLUDE 'PAS$EXT:ADATIM.EXT';
 %INCLUDE 'PAS$EXT:CWOTAS.EXT';
 %INCLUDE 'PAS$EXT:CINTAS.EXT';
 %INCLUDE 'DEBUG.EXT';

 {$List }
 {*CALL*}


  PROCEDURE signal(num: Integer; { error number }
                   param: Integer; { general value }
                   isb: IO_Status_Block;
                   str: PACKED ARRAY [lo..hi: Integer] OF char { aux string }
                   );
    EXTERNAL;

{*USER*

 General message logger for AMIRTR. Puts out message patterned (vaguely) 
after the VMS LIB$SIGNAL stuff. Facility code is "RTR". 
Message numbers are defined here, with a severity code for each. By convention,
positive integers are status messages, negative are errors. Severity is 
'S (Success)' for positive codes, 'F (Fatal)' for negative, unless
otherwise specified. Other values are 'W (Warning)', 'E (Error)',
'I (informational)'.

Writes message to file 'Log_File', which is opened from logical RTR$LOG_FILE
during initialization.  Message format is - 

%RTR-?-ACRONYM - dd-MMM-yy hh:mm:ss - message text 'aux string' 
        Param=nnnnn, DSW=oooooo, IOSB[1]=oooooo, ooooo. 

If const WIDE = TRUE, then a single 132-col line is formatted, else two
80-col lines are used. 

Messages are duplicated to DEBUG_FILE and/or sent to DEBUG_NODE::DEBUG_TASK
as specified by global debug booleans. Debug_level for all statuses
must be 2 or greater. 

Where ACRONYM and message text are defined here, aux string is the STR 
parameter, and the others are obvious. Some intelligence is applied to 
dumping DSW and IOSB params, but if not obvious, they are dumped anyway. 
DSW is not a parameter, it is taken from current value of $DSW. 

See the table Mes_Table in module SIGNAL.INC for definition of messages. 
 }

{*WIZARD*

 }


  PROCEDURE signal;

    CONST
      Prefix = ' %RTR-';
      Wide = FALSE;

    TYPE

      Mes_rec =
        RECORD
          suffix: ch10; { s-AAAAAAAb }
          blurb: ch30;
          Io, dsw, usr: Boolean; { true if to print these }
        END; {mes}

      { define the messages as an array of min-max.}
      Mes_table = ARRAY [ - 25..5] OF Mes_rec;

    CONST

      {[O=80,F-] Pasmac }

      { Note: Error MNemonics are defined in Signal.inc as constants }
      { Here are the messages }

      Messages = Mes_table( 
{n} { ('x-aaaaaaa ', '123456789012345678901234567890',    IO,   DSW,USER)}
{-25} ('?-MISCERR ', 'THIS IS A RANDOM ERR          ', FALSE, FALSE, FALSE),
{-24} ('?-MISCERR ', 'THIS IS A RANDOM ERR          ', FALSE, FALSE, FALSE),
{-23} ('?-MISCERR ', 'THIS IS A RANDOM ERR          ', FALSE, FALSE, FALSE),
{-22} ('?-MISCERR ', 'THIS IS A RANDOM ERR          ', FALSE, FALSE, FALSE),
{-21} ('E-NTMBX   ', 'Random Net Mbx Input (LUN)    ', TRUE,  FALSE, TRUE ),
{-20} ('W-NTINT   ', 'Net Interrupt Msg. Rcvd (LUN) ', TRUE,  FALSE, TRUE ),
{-19} ('W-MSRCV   ', 'MSRCV (receive msg.) failure  ', FALSE, TRUE,  FALSE),
{-18} ('W-NTCON   ', 'Network Connect failure       ', TRUE,  TRUE,  TRUE ),
{-17} ('W-NTCONB  ', 'NTCONB failure                ', TRUE,  TRUE,  TRUE ),
{-16} ('W-MSSEND  ', 'Message Send failure          ', FALSE, TRUE,  TRUE ),
{-15} ('E-NTSND   ', 'Net Send failure (LUN)        ', TRUE,  TRUE,  TRUE ),
{-14} ('W-NTDSC   ', 'Net Link Disconnect (LUN)     ', TRUE,  TRUE,  TRUE ),
{-13} ('E-NTRECF  ', 'Net Receive failure (LUN)     ', TRUE,  TRUE,  TRUE ),
{-12} ('E-NTACCF  ', 'NTACC link accept failure     ', TRUE,  TRUE,  FALSE),
{-11} ('E-NETREJF ', 'NETREJ link reject failure    ', TRUE,  TRUE,  FALSE),
{-10} ('W-DUPLNK  ', 'Rejected duplicate link rqst. ', FALSE, FALSE, FALSE),
{ -9} ('E-MSINIT  ', 'MSINIT Failure                ', TRUE,  FALSE, FALSE),
{ -8} ('W-NOSLOT  ', 'No Net Slots open (rejected)  ', FALSE, FALSE, FALSE),
{ -7} ('F-NOTINIT ', 'Initialization Failure        ', FALSE, FALSE, FALSE),
{ -6} ('E-SRDAERR ', 'Specify Rcv. Data AST Failure ', TRUE,  FALSE, TRUE ),
{ -5} ('E-NTSPA   ', 'Specify Net AST Failure       ', TRUE,  FALSE, TRUE ),
{ -4} ('E-EFNERR  ', 'EFN Routine Failure           ', TRUE,  FALSE, TRUE ),
{ -3} ('E-TRNLOG  ', 'Translate Logical (RLON,TLON) ', TRUE,  FALSE, FALSE),
{ -2} ('E-NTOPEN  ', 'Network Open Failure (DECNET) ', TRUE,  TRUE,  TRUE ),
{ -1} ('E-ALUNERR ', 'Assign LUN Failure            ', TRUE,  FALSE, TRUE ),
{  0} ('?-MISCERR ', 'THIS IS A RANDOM ERR          ', FALSE, FALSE, FALSE),
{  1} ('S-INITFIN ', 'Initialization complete       ', FALSE, FALSE, TRUE ),
{  2} ('S-NTACC   ', 'Network Link Accepted (LUN)   ', FALSE, FALSE, TRUE ),
{  3} ('S-BYEBYE  ', 'Normal Program Shutdown       ', FALSE, FALSE, FALSE),
{  4} ('S-NETCLO  ', 'Network Link Closed (LUN)     ', FALSE, FALSE, TRUE ),
{  5} ('?-MISCERR ', 'THIS IS A RANDOM ERR          ', FALSE, FALSE, FALSE)
     );

{[O=78,F+] Pasmat }

    VAR
      Line1: str132; { first output line }
      line2: str80; { second output line }
      Line3: str199; { local copy of 'str' param }
      dtstr: CH18; { for adatim }
      tstr: CH8; { for time part }
      mes: Mes_rec;
      sav_dsw: Integer; { Local copy of initial $DSW }
      ascnum: CH8; { for conversions }


    BEGIN
      sav_dsw := $DSW; { preserve input DSW }
      mes := Messages[num]; { get message-specific info }
      WITH mes DO
        BEGIN
        ADATIM(dtstr); { get date-time }
        SASSIGN(Line1, Prefix);
        Sconcat(Line1, suffix);
        Sconcat(Line1, dtstr);
        Schconcat(Line1, '-');
        Sconcat(Line1, blurb);
        { build second line - or maybe second half of long line }
        SASSIGN(line2, '    ');
        { dsw, iosb, user }
        IF mes.dsw THEN
          BEGIN
          Sconcat(line2, '$DSW =  ');
          CWOTAS(sav_dsw, ascnum, 0, 8);
          Sconcat(line2, ascnum);
          Sconcat(line2, ',   ')
          END; { if DSW }
        IF mes.Io THEN
          BEGIN
          Sconcat(line2, 'IOSB =  ');
          CWOTAS(isb.int[1], ascnum, 0, 8);
          Sconcat(line2, ascnum);
          Sconcat(line2, ' : ');
          CWOTAS(isb.int[2], ascnum, 0, 8);
          Sconcat(line2, ascnum);
          Sconcat(line2, ',    ')
          END; { if IO }
        IF mes.usr THEN
          BEGIN
          Sconcat(line2, 'UserParam= ');
          cintas(param, ascnum, 0); { this one's decimal }
          Sconcat(line2, ascnum);
          Sconcat(line2, '. ')
          END; { If usr }
        Sconcat(line2, '    ');
        SVassign(Line3, str); { make local copy user string }
        Sconcat(line2, Line3); { stuff user string }
        SASSIGN(Line3, Line1); { make comment string for message output }
        Sconcat(Line3, line2);
        IF (Wide AND (SLen(Line1) + SLen(line2) <= 132)) THEN
          BEGIN
          Sconcat(Line1, line2); { make one big line }
          swrite(log_file, Line1) { put it out }
          END
        ELSE
          BEGIN
          swrite(log_file, Line1);
          writeln(log_file);
          swrite(log_file, line2);
          writeln(log_file)
          END { if wide }
        END; {with}
      IF Debugging AND (Debug_Level >= 2) THEN
        Debug(Line3) { hand off to debug output routine }
    END; { signal }
