{$DOUBLE}
Program DoCtl;
{$nomain}

{ 
  Description: Handle Router Control Messages for AMIRTR 
         File: [AMIRTR]DOCTL.PAS
       Author: Jim Bostwick 
    Last Edit: 14-DEC-1989 15:38:41 
      History:
	 27-NOV-1989 -JMB - make more than a stub...
    	 9-OCT-1989 - JMB - major happy munging...
	 3-AUG-1989 - JMB - Add $DOUBLE compiler switch


}
{$Nolist}
{[a+,b+,l-,k+,r+] Pasmat }
 %INCLUDE 'AMIRTR.PKG';
 %INCLUDE 'DEBUG.EXT';
 %INCLUDE 'Deinit.ext';

{$List }
{*CALL*}

Procedure DoCtl(
	Var Msg: Message_rec
  	);External;

{*USER*

 Handle all router-control messages. These  are messages destined for the 
AMIRTR program itself. 

Packet type/Sub-type combos recognized here: 

PK_DEBUG
    PS_START 	- enable debug with level given
    PS_RESUME	- close, open new version of all debug files
    PS_STOP	- stop debugging
    
PK_MONITOR
    PS_START	- start/restart monitor on given/saved file
    PS_RESUME	- close, open new version of monitor (log) file(s)
    PS_STOP	- stop (all) logging
    
PK_ORDERLY_ABORT - set Exit_Request
    ***NOTE*** - this will take the router to a quiscient state, but may
    		not actually cause it to exit. The router will attempt
    		to shut down all active links, but may hang (waiting for
    		one or more links to drop) due to lack of cooperation at
    		the other end. The guarantee is, however, that it will
    		be OK to abort after this (and a few seconds). 
    
PK_IDENTIFY	- return a friendly message
    
    
	

 }

{*WIZARD*

 }

Procedure  DoCtl;

VAR
    reply: Boolean;
    switch: Boolean; 
    tmp_fnam: str60;
    pos: Integer;
			
BEGIN
    Reply := TRUE; 	{ Assume we want to send reply message. }
    
    Case Msg.id of 
    PK_IDENTITY:
	BEGIN 
	{ Message Router operating on node xxx as task yyy. }
	Sassign(Msg.ident,Trademark);
	END;
    PK_Orderly_abort:
	BEGIN 
	Deinit; { will close logs, initiate shutdown }
	Msg.sub:=[ps_ack];
	END;
    PK_Debug:
	BEGIN
	if ps_close IN msg.sub
	    THEN BEGIN
		If Debug_to_File THEN Close(Debug_file);
		Debug_to_File := false;
		if Debug_to_msg THEN 
		    WITH Debug_msg DO 
			BEGIN 
			id := msg.id;
			sub := msg.sub;
			value := value;
			mssend(debug_msg,f0);
			debug_to_msg := False
			END
		END;
	If ps_open IN msg.sub
	    THEN BEGIN
		If Debug_to_File 
		THEN BEGIN 
		    close(debug_file);
		    Rewrite(debug_file,debug_file_name);
		    
		    END
		ELSE 
		    BEGIN 
		    msg.sub :=[ps_nocando,ps_close]
		    
		    END
		END;
	    
	If ps_open IN msg.sub
	    THEN BEGIN
		If Debug_to_File 
		THEN BEGIN 
		    msg.sub :=[ps_nocando,ps_open];
		    sassign(msg.deb_device,debug_file_name);
		    END
		ELSE 
		    BEGIN 
		    sassign(tmp_fnam,msg.deb_device);
		    
		    END
		END;
  	END;		
  END; {case}
END;

