{$DOUBLE}
Program Debug;
 {$nomain}

{ 
  Description: Various Debug Routines for AMIRTR. 
         File: [AMIRTR]DEBUG.PAS
       Author: Jim Bostwick 
    Last Edit: 5-APR-1990 02:46:43 
      History:

   Contents:    Debug   - Main Debug output handler. 
                DbgIO   - Debug message relative to IO operations. 
                DbgHdr  - Debug Dump of Message Header. 
                OpnDbg  - Open Debug File/Device/Message channel.               
}
 {$Nolist}
 {[a+,b+,l-,k+,r+] Pasmat }
 %INCLUDE 'AMIRTR.pkg';
 %INCLUDE 'pas$ext:adatim.ext';
 %INCLUDE 'pas$ext:cintas.ext';
 %INCLUDE 'pas$ext:cwotas.ext';
 %INCLUDE 'pas$ext:RLON.Ext';
 %INCLUDE 'PAS$EXT:CATR56.EXT';
 %INCLUDE 'PAS$EXT:CR56TA.EXT';

 {$List }
 {*CALL*}


  PROCEDURE Debug(str: PACKED ARRAY [slo..shi: integer] OF char);
    EXTERNAL;

{*USER*
    Central Debug message output routine for AMIRTR. Parameter is 
    a formatted string. It is trademarked, timestampped, and output
    to Debug_file, sent to Debug_node::Debug_task, or both. 
 }

{*WIZARD*

 }

  {*CALL*}


  PROCEDURE dbgio(s: PACKED ARRAY [lo..hi: integer] OF char;
                  ios: io_status_block);
    EXTERNAL;

{*USER*
 This procedure will format a message header and pass resulting string
        to DEBUG for output. It is used for messages pertaining to io. 
        The io status block is formatted into the message. 

}


  PROCEDURE dbghdr(VAR h: message_rec);
    EXTERNAL;

{*USER*
 This procedure will format a message header and pass resulting string
        to DEBUG for output. 

}

  {*CALL*}


  PROCEDURE OpnDbg(fnam: PACKED ARRAY [lo..hi: integer] OF char);
    EXTERNAL;

{*USER*
    Open or re-open the debug file. At program startup, logical
    name "RTR$DBG_FILE" is used. Thereafter, parameter 'fnam' may
    specify a new file (or device). 

    Each time called, the current debug log is closed, and a new one
    opened. If 'fnam' is empty (length = 0), then attempt to translate
    'RTR$DBG_FILE' is made. If translation comes up empty, debug file
    is CLOSED; else, the file named by translation of RTR$DBG_FILE is
    used. 

    If 'fnam' parameter non-empty, attempt to translate 'fnam' as 
    a logical. If translation succeeds, use that as filespec. Else,
    use 'fnam' parameter itself as the filespec. 

    Can you say 'maximum flexibility'? Sure you can...
 }

{*WIZARD*

 }




  PROCEDURE Debug;

    VAR
      instr, str1, str2: str132;
      pref: str40;
      timestamp: ch20; { dd-mmm-yyyy hh:mm:ss format }
      pos, len, rem: integer;


    BEGIN
      adatim(timestamp); { get formatted time }
      Sassign(pref, trademark); { set trademark }
{      sconcat(pref, timestamp);} { set timestamp }
      svassign(instr, str);
      len := slen(str);
      IF debug_to_file THEN
        IF slen(str) + slen(pref) > debug_width THEN
          BEGIN
          rem := debug_width - slen(str1);
          ssubstr(str2, instr, 1, rem);
          sconcat(str1, str2);
          swrite(debug_file, str1);
          writeln(debug_file);
          swrite(debug_file, trademark);
          ssubstr(str2, instr, rem + 1, (slen(str) - rem));
          Sassign(str1, '      ');
          swrite(debug_file, str1);
          swrite(debug_file, str2);
          writeln(debug_file)
          END
        ELSE
          BEGIN
          swrite(debug_file, pref);
          swrite(debug_file, instr);
          writeln(debug_file)
          END;
      { how about messages ? }
      IF Debug_to_msg THEN
        BEGIN
        WITH Debug_msg DO
          BEGIN
          Sassign(comment, pref);
          sconcat(comment, instr)
          END;
        mssend(Debug_msg, f0)
        END
    END; {debug }




  PROCEDURE dbgio;

    VAR
      num: CH6;
      debug_str: str132;
      i, n: integer;


    BEGIN
      svassign(debug_str, s);
      sconcat(debug_str, ' IO Status =');
      cwotas(ios.int[1], num, 0, 10);
      sconcat(debug_str, num);
      schconcat(debug_str, ':');
      cwotas(ios.int[2], num, 0, 10);
      sconcat(debug_str, num);
      sconcat(debug_str, ' [');
      FOR i := 1 TO 4 DO
        BEGIN
        n := ios.byt[n];
        cwotas(n, num, 0, 10);
        sconcat(debug_str, num);
        schconcat(debug_str, ':')
        END;
      schconcat(debug_str, ']');
      Debug(debug_str)
    END;




  PROCEDURE OpnDbg;

    VAR
      Fspec: str40;
      len: integer;


    BEGIN
      svassign(Fspec, fnam); { get local copy of param }
      IF slen(fnam) = 0 THEN
        BEGIN
        RLON('RTR$DEBUG_FILE', Debug_file_name, len);
        IF ($dsw = 1) AND (len > 0) THEN debug_to_file := TRUE
        END
      ELSE { fnam non-empty }
        BEGIN
        debug_to_file := TRUE;
        RLON(Fspec, Debug_file_name, len);
        IF NOT (($dsw = 1) AND (len > 0)) THEN
          Sassign(Debug_file_name, Fspec)
        END;
      IF debug_to_file THEN
        BEGIN
        Rewrite(debug_file, Debug_file_name);
        Debugging := TRUE;
        END
      ELSE IF slen(Debug_file_name) <> 0 THEN
        BEGIN
        Close(debug_file);
        debug_to_file := false
        END
    END;




  PROCEDURE dbghdr;

    VAR
      nam: CH6;
      debug_str: str132;


    BEGIN
      cr56ta(h.dest_task, nam);
      Sassign(debug_str, 'Destination ');
      sconcat(debug_str, h.dest_node);
      sconcat(debug_str, '::');
      sconcat(debug_str, nam);
      cr56ta(h.src_task, nam);
      sconcat(debug_str, '  From ');
      sconcat(debug_str, h.src_node);
      sconcat(debug_str, '::');
      sconcat(debug_str, nam);
      cr56ta(h.router, nam);
      sconcat(debug_str, ' Via router ');
      sconcat(debug_str, nam);
      sconcat(debug_str, ' with size =');
      cintas(h.Msg_size, nam, 1);
      sconcat(debug_str, nam);
      sconcat(debug_str, '. ');
      Debug(debug_str)
    END;


