{$DOUBLE}
Program AMIRTR;

{ 
  Description: AMI Network Message Router for RSX
         File: [AMIRTR]AMIRTR.PAS
       Author: Jim Bostwick  6-DEC-1988 
    Last Edit: 9-APR-1990 23:28:12 
      History: 
         9-OCT-1989 - JMB - major happy munging...
         3-AUG-1989 - JMB - Add $DOUBLE compiler switch
        28-JAN-1989 - JMB - Reworked Link array structure


}
 {$Nolist}
 {[a+,b+,l-,k+,r+] Pasmat }
 %INCLUDE 'AMIRTR.PKG'; { drag in all externals }
 %INCLUDE 'PAS$EXT:WTSE.EXT';
 %INCLUDE 'pas$ext:clef.ext';
 %INCLUDE 'init.ext';
 %INCLUDE 'domail.ext';
 %INCLUDE 'netin.ext';
 %INCLUDE 'msgin.ext';
 %INCLUDE 'signal.ext';
 %INCLUDE 'deinit.ext';

 {$List }

{ 
  This is the main routine for AMIRTR. See accompaning docs for 
   details. 
 }
 { NON-Global (logically, anyway) variables }

  VAR
    sav_dsw: Integer; { saved copy of $DSW }


  BEGIN
    Exit_Request := FALSE;
    Init(Status); { do the usual initialization garbage }
    IF (Status < 0) THEN Signal( - 7, Status, IOSB, ' exiting.')
    ELSE
{
  Process events. Priority of service is as follows:
        1. Net Mailbox info (loop thru all).
        2. Net Data Input (one per link ). 
        3. Receive data queue (loop thru all). 
 The above loop is run until nothing is ready to go. Then sleep. 
 The flag is cleared immediately upon wake-up to allow additional
   events which occur during processing loop to be detected. Because
   we completely flush the net mailbox and receive-data queues, and 
   use QIO to do net data input, there is no window-of-unseen-message.
}
      WHILE NOT (Exit_Request) DO
        BEGIN 		{ having initialized, do our thing }
        WTSE(Net_EFN); 	{ wait for something to happen }
        CLEF(Net_EFN); 	{ clear the flag }
        L := 0;
        DOMAIL; 	{ process net mailbox }
        FOR L := 1 TO Max_Links DO
          IF (Link[L].Read_IOSB.int[1] <> 0) THEN NETIN(L); { process net
          input }
        REPEAT
          MSRCV(Null_Task_Name, Loc_Msg); { Receive Data? }
          sav_dsw := $dsw;
          IF ($dsw >= 1) THEN MSGIN(Loc_Msg) { yep - process new message }
          ELSE IF ($dsw <> - 8) { not benign... }
                  THEN
            Signal(Sig_MSRCV, 0, Null_IOSB, ' MAIN ');
        UNTIL (sav_dsw < 0); { until empty (-8) or failure }
        END; { while }
{ 
  If exit_request, call closeup for clean shutdown, else assume init error
    and just quit. 
  }
    IF Exit_Request THEN DEINIT
  END. { AMIRTR }
