{$DOUBLE}
Program MSGIN;
 {$nomain}

{ 
  Description: Received Message routing for AMIRTR
         File: [AMIRTR]MSGIN.PAS
       Author: Jim Bostwick 
    Last Edit: 14-DEC-1989 17:07:07 
      History:
         11-OCT-1989 -JMB - Must copy dest task before forwarding...
         9-OCT-1989 - JMB - Major happy munging...
         3-AUG-1989 - JMB - Add $DOUBLE compiler switch


}
 {$Nolist}
 {[a+,b+,l-,k+,r+] Pasmat }
 %INCLUDE 'AMIRTR.PKG';
 %INCLUDE 'SIGNAL.EXT';
 %INCLUDE 'GETLNK.EXT';
 %INCLUDE 'DoCTL.EXT';
 %INCLUDE 'Dbghdr.ext';
 %INCLUDE 'pas$ext:CR56TA.ext';

 {$List }
 {*CALL*}


  PROCEDURE MsgIn(VAR Msg: Message_rec);
    EXTERNAL;

{*USER*

 This procedure handles messages received from the local node (via VRCD), or
from a remote link (via NtRCV). Routing is the same in either case. 
Possibilities are:

    1. Message destination is same node (usually testing only): 
        If message is a router-control message, give it to RTRCTL. 
        Else message is routed directly from here to SMSG. Done. 
    2. Message destination is different node: 
        Check that we have a link to that node. If not, attempt to 
        establish one. Once link is found, send message via NtSND.              
 }

{*WIZARD*

 }


  PROCEDURE MsgIn;

    VAR
      L, I: Integer; { node (link) index }
      IOSB: IO_STATUS_BLOCK;
      tnam: ch6;


    BEGIN
      Writeln(log_file, 'MSGIN - entry...');
      dbghdr(loc_msg);
      WITH loc_msg DO
        BEGIN
        IF SEqual(Dest_Node, MyNode) THEN
          BEGIN
          { Local destination, is it for us or a task? }
          IF Msg_Router_Ctrl IN Flags THEN DoCTL(loc_msg)
          ELSE
            BEGIN
            cr56ta(dest_task, tnam);
            Writeln(log_file, 'MSGIN - Mssend for ', tnam, '. ');
            Router := dest_task; { Set new destination }
            MsSend(loc_msg, AUX_efn); { And send it on }
            Writeln(log_file, 'MSGIN - mssend DSW=', $DSW)
            END
            { Later, handle MSG_Wake and MSG_Run here !!! }
          END { Local handling }
        ELSE
          BEGIN
          { Destination is another node. }
          Writeln(log_file, 'MSGIN - calling GETLNK for <', Dest_Node, '>.');
          GetLnk(loc_msg, L); { Locate or create link }
          IF (L > 0) THEN
            WITH LINK[L] DO
              BEGIN
              Writeln(log_file, 'MSGIN - calling NTSND for link ', L, '.');
              NTSND(lun, Net_Efn, Loophole(address, ref(loc_msg)),
                    MsSize(loc_msg), IOSB);
              IF ((IOSB.Int[1] <> 1) OR ($DSW <> 1)) THEN
                SIGNAL(Sig_NtSnd, lun, IOSB, ' MsgIn ')
              ELSE
                WITH Stats DO
                  BEGIN
                  Writes := Writes + 1;
                  Last_Activity := 0
                  END { With Stats}
              END; { With LINK }
          END; { ELSE }
        END {with msg }
    END; { Procedure MsgIN }
