			.ENABLE SUBSTITUTION
			.ENABLE GLOBAL
;
;	G R E P . C M D
;
;	This command file assembles and links the GREP task image
;
;	The following commands may be passed on the invoking line:
;
;	"CREF"		"NOCREF"		Default:  NOCREF
;	"LIST"		"NOLIST"		Default:  NOLIST
;	"MAC"		"NOMAC"			Default:  MAC
;	"MAP"		"NOMAP"			Default:  NOMAP
;	"ODT"		"NOODT"			Default:  NOODT
;	"TKB"		"NOTKB"			Default:  TKB
;	

.;	=================================================================
.;	Parse passed commands on invoking line
			.BEGIN
			.SETT $ASM
			.SETS $LST "NL:"
			.SETS $DBG ""
			.SETS $MAP "NL:"
			.SETS $TCR ""
			.SETT $LNK
.IF <STRLEN> = 1	.GOTO 10
			.SETN NUMARG <STRLEN>-1
.PARSTR:		.SETS TST P'NUMARG'
.IF TST = "MAC"		.SETT $ASM
.IF TST = "NOMAC"	.SETF $ASM
.IF TST = "NOLIST"	.SETS $LST "NL:"
.IF TST = "LIST"	.SETS $LST "SY:"
.IF TST = "NOODT"	.SETS $DBG ""
.IF TST = "ODT"		.SETS $DBG "/DA"
.IF TST = "NOMAP"	.SETS $MAP "NL:"
.IF TST = "MAP"		.SETS $MAP "SY:"
.IF TST = "NOCREF"	.SETS $TCR ""
.IF TST = "CREF"	.SETS $TCR "/CR"
.IF TST = "TKB"		.SETT $LNK
.IF TST = "NOTKB" 	.SETF $LNK
			.DEC NUMARG
.IF NUMARG <> 0		.GOTO PARSTR
.10:
			.END
.;	=================================================================


.;	=================================================================
.;	Make sure an assembler is installed
			.BEGIN
			.SETS $MAC "MAC"
.IFINS ...'$MAC'	.GOTO 10
			Install $'$MAC'
.IFINS ...'$MAC'	.GOTO 10
			.SETS $MAC "PMA"
.IFINS ...'$MAC'	.GOTO 10
			Install $'$MAC'
.IFINS ...'$MAC'	.GOTO 10
;
;	No assembler installed or installable.  Install it and try again.
;
			.STOP
.10:
.IF <CLI> NE "MCR"	.SETS $MAC "MCR "+$MAC
			.END
.;	=================================================================


.;	=================================================================
.;	Make sure PIP is installed
			.BEGIN
.IFINS ...PIP		.GOTO 10
			Install $PIP
.IFINS ...LBR		.GOTO 10
;
;	PIP not installed or installable.  Install it and try again.
;
			.STOP
.10:
			.SETS $PIP "PIP"
.IF <CLI> NE "MCR"	.SETS $PIP "MCR PIP"
			.END
.;	=================================================================


.;	=================================================================
.;	Make sure a Taskbuilder is installed
			.BEGIN
			.SETS $TKB "TKB"
.IFINS ...'$TKB'	.GOTO 10
			Install $'$TKB'
.IFINS ...'$TKB'	.GOTO 10
			.SETS $TKB "PAB"
.IFINS ...'$TKB'	.GOTO 10
			Install $'$TKB'
.IFINS ...'$TKB'	.GOTO 10
;
;	No Taskbuilder installed or installable.  Install it and try again.
;
			.STOP
.10:
.IF <CLI> NE "MCR"	.SETS $TKB "MCR "+$TKB
			.END
.;	=================================================================


.;	=================================================================
.;	Assemble it
			.BEGIN
.IFF $ASM		.GOTO 20
;
;	Assembly segment
;
			'$PIP' GREP.OBJ;*/NM/DE
			.TESTFILE GREP.MAC
.IF <FILERR> EQ 1	.GOTO 10
;
;	File GREP.MAC is missing.  Replace it and try again.
;
			.EXIT
.10:
			'$MAC' GREP, '$LST'GREP = GREP
.IF <EXSTAT> EQ 1	.GOTO 20
;
;	Assembly of GREP.MAC failed.  Correct it and try again.
;
			.EXIT
.20:
			.END
.;	=================================================================


.;	=================================================================
.;	Build it
			.BEGIN
.IFF $LNK		.GOTO 20
;
;	Taskbuild segment
;
			.TESTFILE GREP.OBJ
.IF <FILERR> EQ 1	.GOTO 10
;
;	File GREP.OBJ is missing.  Replace it and try again.
;
			.EXIT
.10:
			'$PIP' GREP.TSK;*/NM/DE
			'$PIP' GREP.MAP;*/NM/DE
			.OPEN #1 GREPBLD.CMD
			.DATA #1 GREP/-FP/CP/-SE/MM'$DBG', '$MAP'GREP'$TCR' = GREP
			.DATA #1 /
			.DATA #1 TASK=...GRE
			.DATA #1 //
			.CLOSE #1
			'$TKB' @GREPBLD
.IF <EXSTAT> EQ 1	.GOTO 20
;
;	Linking of GREP.MAC failed.  Correct it and try again.
;
.20:
			'$PIP' GREPBLD.CMD;*/NM/DE
			.END
.;	=================================================================
