
/* Define the QIO function codes */

#define IO_XTM  (031*0400)	/* Transmit */
#define IO_XRC  (032*0400)	/* Receive */
#define IO_XOP  (033*0400)	/* Open a line */
#define IO_XTR  (034*0400)	/* Terminate */
#define IO_XIN  (035*0400)	/* Initialise */
#define IO_XTL  (036*0400)	/* Control */
#define IO_XCH  (037*0400)	/* Characteristics */

/* Define subfunction codes */

/* IO_XTR subfunctions */

#define XF_STP  010		/* Stop only, no deassign */
#define XF_STD  0200		/* Stop & disable, close LUN & deassign */

/* IO_XTL subfunctions */

#define XF_ON  0		/* Turn a line-id on */
#define XF_OFF  010		/* Turn a line-id off */
#define XF_REA  020		/* Reassign a line-id */
#define XF_ASS  030		/* Assign a line-id */
#define XF_DEA  040		/* Deassign a line-id */
                               
/* IO_XCH subfunctions */

#define XF_SMC  0       	/* Set multiple characteristics */
#define XF_GMC  010		/* Get multiple characteristics */

/* Define compound function codes */

#define IO_XSP  IO_XTL|XF_OFF		/* Stop a line */
#define IO_XST  IO_XTL|XF_ON	        /* Start a line */
#define IO_XHG  IO_XTR	         	/* Hang up a line */
#define IO_XCL  IO_XTR|XF_STP|XF_STD	/* Close a line */
#define IO_XSC  IO_XCH|XF_SMC		/* Set multiple characteristics */
#define IO_XGC  IO_XCH|XF_GMC		/* Get multiple characteristics */

/* Define maximum DLC protocol overheads */

#define PRO$OV  0      		/* No longer needed - defined to zero to */
#define CRC$OV  0      		/*    resolve any references to these symbols */

/*
   Define device type codes 
   (returned in high byte of I/O status word 1 on open)
*/

#define XV_OTH         	000000		/* 'Others' - non-ethernet */ 
#define XV_BRO   	000001		/* Broadcast channel */

/* Define 802 frame format, service class symbols */

#define NX$ETH	   01	/* Ethernet frames */
#define NX$802	   02	/* 802_3 frames */
#define NX$CLI	   04	/* 802_2 Class I service */
#define NX$ADR	   010	/* Ethernet address	(RESERVED for internal use) */
#define NX$PRO	   020	/* Ethernet protocol	(RESERVED for internal use) */
#define NX$SAP	   040	/* 802_3 SAP		(RESERVED for internal use) */
#define NX$CTL	   0100	/* 802_3 CTL field	(RESERVED for internal use) */
#define NX$SNP	   0200	/* 802_3 SNAP protocol 	(RESERVED for internal use) */

