/* ERRCHK.H - Error Checking Functions
 *
 * Language: DECUS-C
 *   Author: Juergen Pinkow
 *     Date: August '89
 *
 */


/*     	*** Completion error ***
 *
 *      This routine checks the Directive Status Word and the 
 *	IO - Completion Status after a call to the Executive.
 *	Task exit on error.
 *      Arguments:  - Zero terminated ASCII string error message
 *		    - Directive Status Word
 *	 	    - Address of Completion Status Word
 */

cmperr(msg,dswerr,stat) 
char *msg;
int   dswerr;
int   stat[];
{
 int errflg;

 errflg = 0;

 if ((dswerr&0x00ff) != IS_SUC)
   {
    errflg = 1;
    printf("DIRECTIVE-ERROR: %d\n",(char)dswerr);
   }

 if ((stat[0]&0x00ff) != IS_SUC && (stat[0]&0x00ff) != 0)
   {
    errflg = 1;
    printf("COMPLETION-ERROR (1st Word): %d (High Byte) %d (Low Byte)\n",
			 	               stat[0]>>8,(char)stat[0]);
    printf("                 (2nd Word): %d (High Byte) %d (Low Byte)\n",
					       stat[1]>>8,(char)stat[1]);
   }

 if (errflg)
   {
    printf("ERROR: %s\n",msg);
    exit();
   }
}

/*  	*** Characteristics error ***
 *
 *	Checks the Status Word within the characteristics buffer.
 *      Task exit on error.
 *      Arguments:  - Zero terminated ASCII string error message
 *		    - Characteristics Status Word	
 */

chrerr(msg,status)
 char *msg;
 int   status;
{
 if ((status&0x00ff) != CS_SUC)
   {
    printf("CHARACTERISTICS-ERROR: %d %s\n",(char)status,msg);
    exit();
   }
}
