/* TTIO.h - Terminal IO - Functions using QIO's 
 * 
 * Author: Juergen Pinkow
 *   Date: August '89
 *
 */

#define  TILUN   5	 /* Logical unit number for Terminal-IO      */


/*	*** Read String ***
 *
 *	Arguments: - Buffer Address 
 *		   - Maximum number of characters to read
 *
 */ 

reads(str,len)
 char *str;
 int   len;
{
 word  devpar[6],
       iosb[2],
       dsw;
 
 devpar[0] = str; /* Address of data buffer       */
 devpar[1] = len; /* Maximum number of characters to read */
 devpar[2] = 0;
 dsw = qiow(IO_RLB,TILUN,1,iosb,0,devpar);
 cmperr("Function reads() : IO_RLB failed",dsw,iosb);
 str[iosb[1]] = 0; /* Mark end of string */
}


/* 	*** Read Integer ***
 *
 *      Reads a decimal integer number from the terminal
 * 	Arguments : Address of an integer variable
 */

readi(i)
 int *i;
{
 word  devpar[6],
       iosb[2],
       dsw;
 char  numstr[6];

 devpar[0] = numstr; /* Address of data buffer       */
 devpar[1] = 5;      /* Maximum number of characters to read */
 devpar[2] = 0;
 dsw = qiow(IO_RLB,TILUN,1,iosb,0,devpar);
 cmperr("Function reads() : IO_RLB failed",dsw,iosb);
 numstr[iosb[1]] = 0; /* Mark end of string */
                      /* iosb[1] contains the number of bytes read */
 *i = atoi(numstr);
}


writes(string)
 char *string;
{
 word  devpar[6];
 word  iosb[2];
 word  dsw;

 devpar[0] = string;
             
 if ((devpar[1] = strlen(string)) != 0)
   {
    devpar[0] = string; 
    devpar[2] = 0;

    dsw = qiow(IO_WLB,TILUN,1,iosb,0,devpar);
    cmperr("Function writes()",dsw,iosb); 
   }
} 

writec(c)
  char c;
{
 word  devpar[6];
 word  iosb[2];
 word  dsw;

 devpar[0] = &c;
 devpar[1] = 1;
 devpar[2] = 0;

 dsw = qiow(IO_WLB,5,1,iosb,0,devpar);
 cmperr("Function writec()",dsw,iosb);
} 

writei(i) 
   int i;
{
 word  devpar[6];
 word  iosb[2];
 word  dsw;

 char  numstr[5];

 itoa(i,numstr);
 devpar[0] = &numstr;
 devpar[1] = strlen(numstr); 
 devpar[2] = 0;

 dsw = qiow(IO_WLB,5,1,iosb,0,devpar);
 cmperr("writei string",dsw,iosb);
} 
