/* Primary line table */

#define C$TMR   0	/* Timer cell */
#define C$RTMR  1	/* Timer reset value */
#define C$LIN   2	/* System line number */
#define C$FLG   3	/* Controller flags */
#define C$ACT   4	/* Count of active ports-1 */
#define C$STR   5	/* Count of started ports-1 */
#define C$WORK  6 	/* Local workspace */
#define C$DADD	14	/* Destination address from last received message */
#define C$SADD	20	/* Source address from last received message */
#define C$PRO	26	/* Protocol from last received message */
#define C$CTLQ	32	/* Pending control function queue */
#define C$CTLF	36	/* Active control function */
#define C$MANQ	38	/* Pending network management function queue */
#define C$DDM	42	/* DDM PDV index for network management function */
  	          	/* Second byte of C$DDM not used */
#define C$SID	44	/* Timer cell for system ID message */
#define C$REF	46	/* Timer refresh value */
#define C$HADD	48	/* Device hardware address */
#define C$EXT	54	/* Line table extension for network management */
#define C$DAO	62	/* Counter - Data overrun */
#define C$UNFD	64	/* Counter - Unrecognized frame destination */
#define C$PORT	68	/* Port table listhead */
#define C$PROT	72	/* Protocol listhead */
#define C$ISAP	76	/* Individual SAP address list */
#define C$SNAP	78	/* SNAP protocol address listhead */
#define C$MONP	82	/* Datalink monitor port address */
#define C$MONM	84	/* Datalink monitor mask#define */
#define C$MOND	86	/* Datalink monitor DDM controller mode */
#define C$R802	88	/* Counter - Received 802.3 frames */
#define C$X802	90	/* Counter - Transmitted 802.3 frames */
#define C$B802	92	/* Counter - Bad 802.3 frames */
#define C$BLEN	94	/* Counter - Bad length frames */
#define C$LEN   96
#define $$LCNT  C$LEN

/* Controller flags */

#define CF$ENA  000001 	/* Enable protocols and multicast addresses to device */
#define CF$MAN	000002	/* Network management request active */
#define CF$SID	000004	/* System ID message sent by DDM or device */
#define CF$CHN	000010	/* DDM supports chains */

/* Datalink monitor mask#define flags */

#define CM$FRM	000001	/* Receive all frames (Ethernet or 802.3) */
#define CM$PRO	000002	/* Receive all Ethernet protocol types */
#define CM$ADD	000004	/* Receive all source datalink addresses */
#define CM$SNP	000010	/* Receive all 802 SNAP protocol identifiers */
#define CM$DNA	000020	/* Receive all 802 DNA protocol types */
#define CM$ISP	000040	/* Receive all individual SAP's */
#define CM$GSP	000100	/* Receive all group SAP's */
#define CM$PRM	0100000	/* Receive all destination datalink addresses */
		  	/* (I.e., put controller into "promiscuous" mode) */

/* Port table */

#define P$LNK	0	/* Link pointer */
#define P$LIN	2	/* SLN and logical station number (port) */
#define P$FLG	4	/* Port flags */
			/* Second byte of P$FLG not used */
#define P$MCST	6	/* Multicast listhead */
#define P$ZER	10	/* Seconds since last zeroed */
#define P$DBR	12	/* Data blocks received */
#define P$BYR	16	/* Bytes received */
#define P$DBS	20	/* Data blocks sent */
#define P$BYS	24	/* Bytes sent */
#define P$UBU	28	/* User buffer unavailable */
#define P$SPU	30	/* Individual SAP usage count */
#define P$SNU	31	/* SNAP SAP usage count */
#define P$GSP	32	/* Group SAP bitmap address */
#define P$LEN   34
#define $$LLIN  P$LEN

/* Port flags */

#define PF$CHN  01	/* Chained buffers supported */
#define PF$ETH  02	/* Accepts Ethernet frames */
#define PF$802  04	/* Accepts 802.3 frames */
#define PF$CLI	010	/* Class I service enabled */
#define PF$GBL	020	/* Global SAP (FF hex) is enabled */
#define PF$ACT	0200	/* Port is active (started) */

/* Protocol block */


#define L$LNK	0	/* Link #define */
#define L$FLG	2	/* Protocol flags */
#define L$USE	3	/* Use count */
#define L$PRO	4	/* Protocol */
                	/* location L$PRO[5] is reserved */
#define L$DEF	10	/* Pointer to default port */
#define L$EXC	10	/* Pointer to exclusive port */
#define L$ADD	12	/* Address chain listhead */
#define L$LEN	16	/* Length of protocol list entry */

#define LF$EXC	01	/* Exclusive access protocol */
#define LF$DEF	02	/* Default user defined */
#define LF$PAD	04	/* Protocol requires padding */
#define LF$802	010	/* Protocol is 802.2 SNAP identifier */
#define LF$DIS	020	/* Protocol is marked for disable */
#define LF$PRM	0200	/* Permanent protocol */

/* Individual SAP block */


#define I$LNK	0	/* Link to next ISAP */
#define I$UTL	2	/* Utility thread #define */
#define I$BUF	4	/* Buffer chain address */
#define I$ISP	6	/* Individual SAP address */
#define I$USE	7	/* ISAP usage count (0=disabled) */
#define I$PRT	8	/* Owning port */
#define I$LEN   10

/* Group SAP bitmap block */


#define G$BMP	0	/* Group SAP bitmap */
#define G$GSN	8	/* Last group SAP seen (temporary) */
#define G$GSU	9	/* Number of groups in use */
#define G$ISP	10	/* Individual SAP list for receive */
#define G$LEN   12

/* Address block */


#define A$LNK	0	/* Link pointer */
#define A$ADD	2	/* Ethernet address */
#define A$PRT	8	/* Address of owning port */
#define A$LEN   10

/* Multicast address block */

#define M$LNK	0	/* Link pointer */
#define M$ADD	2	/* Multicast address */
#define M$LEN   8

