
/* Set/Get characteristics buffer format */


#define C_TYP   0	/* Characteristics type code */
#define C_DATI  1	/* # of bytes of input */
#define C_DATO  2       /* # of bytes of output */
#define C_STAT  3	/* Status return */
#define C_CHRL  4	/* Minimum length of characteristics buffer */

/* Define set/get characteristics codes */

/* 1. PAM functions */

#define CC_NET	000000		/* DECnet characteristics */
#define CC_SPL	000002		/* Load special character table */
#define CC_LCR	000004		/* Dash Bus window registers */
#define CC_PDC	000006		/* Protocol-dependent parameters */
#define CC_SAD	000010		/* Station address */

/* 2. DLX Ethernet functions */

#define CC_ADR	000100		/* Define address for message */
#define CC_PRO	000101		/* Define protocol for message */
#define CC_DAD	000102		/* Get destination address from message */
#define CC_FMO	000103		/* Define Ethernet/802.3 frame format for open */
#define CC_SCO	000104		/* Define 802.2 service class for open */
#define CC_FMM	000105		/* Define Ethernet/802.3 frame format for message */
#define CC_SPM	000106		/* Define 802.2 DSAP/SSAP for message */
#define CC_CTM	000107		/* Define 802.2 control field for message */
#define CC_SNM	000110		/* Define 802.2 SNAP SAP protocol for message */

/* 3. EPM functions */

#define CC_DST	000200		/* Define remote address/protocol pair */
#define CC_MCT	000201		/* Define multicast address list */
#define CC_FRM	000202		/* Ethernet/802.3 frame format */
#define CC_SRV	000203		/* 802.2 service type */
#define CC_ISP	000204		/* 802.2 individual SAP address */
#define CC_GSP	000205		/* 802.2 group SAP address */
#define CC_SNP	000206		/* 802.2 SNAP protocol identifier  */
#define CC_MON	000207		/* Datalink monitoring */
#define CC_DNA	000210		/* 802.2 DNA private protocol SNAP */

/* 4. Ethernet device driver functions */

#define CC_EMC	000300		/* Enable Ethernet multicast addresses */
#define CC_EPR	000301		/* Enable Ethernet protocol types */
#define CC_DPA	000302		/* Ethernet Default Physical Address */
#define CC_EPH	000303		/* Ethernet Pysical Address */
#define CC_ELS	000304		/* Ethernet Load Server Address (UNA only) */
#define CC_SID	000305		/* System ID */
#define CC_LDM	000306		/* Load/Dump Memory */
#define CC_LSA	000307		/* Load and Start at Address (UNA only) */
#define CC_ECS	000310		/* Ethernet Channel Status */
#define CC_ECM	000311		/* Ethernet Channel Mode */
#define CC_STM	000312		/* Sanity timer enable (QNA only) */
#define CC_PSW	000313		/* Set remote boot password (QNA only) */

/* Define standard status codes (positive success, negative error) */

#define CS_SUC	000001		/* Success */
#define CS_IGN	000002		/* Characteristics block has been ignored */
#define CS_DAO	000003		/* Data overrun */
#define CE_UDF	0100001		/* Undefined characteristic type */
#define CE_INV	0100002		/* Invalid operation */
#define CE_RTL	0100003		/* Request too large */
#define CE_RTS	0100004		/* Request too small */
#define CE_DNF	0100005		/* Device not functioning */
#define CE_ILC	0100006		/* Illegal line card register (PAM) */
#define CE_MCE	0100007		/* Multicast address already enabled (Ethernet) */
#define CE_RES	0100010		/* Resource allocation failure (Ethernet) */
#define CE_PCN	0100011		/* Protocol usage conflict (Ethernet) */
#define CE_ACN	0100012		/* Address usage conflict (Ethernet) */
#define CE_IUM	0100013		/* Illegal use of multicast address (Ethernet) */
#define CE_NMA	0100014		/* Not a multicast address (Ethernet) */
#define CE_FMI	0100015		/* Illegal frame format (802) */
#define CE_FMC	0100016		/* Frame usage conflict (802) */
#define CE_SRI	0100017		/* Illegal service type (802) */
#define CE_SPU	0100020		/* SAP address in use (802) */
#define CE_SNU	0100021		/* SNAP protocol identifier in use (802) */
#define CE_SPC	0100022		/* SAP usage conflict (802) */
#define CE_BOC	0100023		/* Bad open characteristics buffer (802) */
#define CE_MON	0100024		/* Datalink monitor in use/not in use */

/* Define protocol types */

#define CP_LOO	000220		/* Loopback (cross-company)	90-00 */
#define CP_DUM	000540		/* Dump/Load (Digital)		60-01 */
#define CP_CON	001140		/* Remote console (Digital)	60-02 */
#define CP_ROU	001540		/* Routing (Digital)		60-03 */
#define CP_LAT	002140		/* LAT (Digital)		60-04 */

/* Define multicast addresses */

#define CM_LO1	000317		/* First word of Loopback	CF-00 */
#define CM_LO2	000000		/* Second word			00-00 */
#define CM_LO3	000000		/* Third word			00-00 */
#define CM_DM1	000253		/* First word of Dump/Load 	AB-00 */
#define CM_DM2	000400		/* Second word			00-01 */
#define CM_DM3	000000		/* Third word			00-00 */
#define CM_RC1	000253		/* First word of Remote console	AB-00 */
#define CM_RC2	001000		/* Seconds word			00-02 */
#define CM_RC3	000000		/* Third word			00-00 */
#define CM_LT1	000011		/* First word of LAT		09-00 */
#define CM_LT2	000053		/* Second word			2B-00 */
#define CM_LT3	007400		/* Third word 			00-0F */

