;+
;		TEM.CMD
;
;	Assemble and taskbuild TEM, the Terminal EMulator.
;-
	.ENABLE SUBSTITUTION
	.SETS CLIPRE ""
	.SETS TSKFIL "TEM"
	.SETN RSXVER 40.
	.SETS TSK "TSK"
	.SETF VAXBUG
	.IF <SYSTEM> = 5	.SETS TSK "EXE"
	.IFNDF <PRIVIL>	.GOTO NOBLD
	.IFDF <CLI>	.IF <CLI> <> "MCR"	.SETS CLIPRE "MCR "
	.ASK [<TRUE>] CLEAN Do you want to clean up old TEMs before rebuild
	.ASK [<TRUE>] M40 Is this TEM to run on at least M4.0 or M+2.0
	.IFF M40	.SETN RSXVER 32.
	.IFT M40	.IFDF <VERSN>	.SETN RSXVER 50.
	.ASK [<FALSE>] RSX11S Do you want to build TEM for RSX11S
	.ASK [<FALSE>] TRC Do you want to assemble trace code
	.SETF EGC
	.SETF SET
	.SETF ACT
	.ASKN [132.:4096.:512.] BUFSIZ What file I/O buffer size do you want
	.SETN RNGMIN BUFSIZ
	.SETN INRDEF 2048.
	.SETN OURDEF 512.
	.IF INRDEF < RNGMIN	.SETN INRDEF RNGMIN
	.IF OURDEF < RNGMIN	.SETN OURDEF RNGMIN
	.ASKN [RNGMIN:8192.:INRDEF] INRSIZ What inbound ring size do you want
	.ASKN [RNGMIN:8192.:OURDEF] OURSIZ What outbound ring size do you want
	.SETN BUFSIZ BUFSIZ+0.
	.IFF RSX11S	.ASK [<FALSE>] EGC Do you want to link to EGCML
	.IFF RSX11S	.ASK [<TRUE>] SET Do you want line setup command files
	.IFF RSX11S	.ASK [<TRUE>] ACT Do you want usage accounting
	.IFT RSX11S	.SETS TSKFIL "TEM11S"
	.IF <SYSTEM> = 5 ;
	.IF <SYSTEM> = 5 ;	Certain versions of the VAX-11 RSX run-time system contain a bug
	.IF <SYSTEM> = 5 ;	that prevents versions of TEM built under them from finding
	.IF <SYSTEM> = 5 ;	their own default directories when transported to a system that
	.IF <SYSTEM> = 5 ;	does not have named directory support. Answer the following
	.IF <SYSTEM> = 5 ;	"Y" ONLY if you encounter this problem.
	.IF <SYSTEM> = 5 ;
	.IF <SYSTEM> = 5 .ASK [VAXBUG] VAXBUG Do you need support for the VMS default directory bug
	;
	'CLIPRE'PIP TEMPRE.MAC;*/DE/NM
	.IFT CLEAN	'CLIPRE'PIP TEM.MAC/PU/NM & *.*;1/RE=TEM.MAC
	.IFT CLEAN	'CLIPRE'PIP TEM.OBJ;*/DE/NM,.LST;*,'TSKFIL'.'TSK';*,.MAP;*
	.SETS PREFIX "TEMPRE,"
	.IF RSXVER <> 40.	.GOTO PREFIT
	.IF BUFSIZ <> 512.	.GOTO PREFIT
	.IF INRSIZ <> INRDEF	.GOTO PREFIT
	.IF OURSIZ <> OURDEF	.GOTO PREFIT
	.IFT TRC	.GOTO PREFIT
	.IFT EGC	.GOTO PREFIT
	.IFF SET	.GOTO PREFIT
	.IFF ACT	.GOTO PREFIT
	.IFT VAXBUG	.GOTO PREFIT
	.SETS PREFIX ""
	.GOTO MACIT
.PREFIT:.OPEN TEMPRE.MAC
			.DATA RSXVER = 'RSXVER'.
	.IF BUFSIZ <> 512.	.DATA BUFSIZ = 'BUFSIZ'.
	.IF INRSIZ <> INRDEF	.DATA INRSIZ = 'INRSIZ'.
	.IF OURSIZ <> OURDEF	.DATA OURSIZ = 'OURSIZ'.
	.IFT TRC	.DATA TRACE = 1
	.IFT EGC	.DATA EXGTCM = 1
	.IFF SET	.DATA LINSET = 0
	.IFF ACT	.DATA ACCNTG = 0
	.IFT VAXBUG	.DATA VAXBUG = 1
	.CLOSE
.MACIT:	'CLIPRE'MAC TEM,TEM/-SP='PREFIX'TEM
	.IFF RSX11S	'CLIPRE'TKB @TEMBLD
	.IFT RSX11S	'CLIPRE'TKB @TEM11SBLD
.EXIT:	.;
	.EXIT

.NOBLD:	;
	; Error - You cannot build TEM on this system. You need at least
	;         one of the following:
	;		RSX-11M V4.0 or higher
	;		RSX-11M+ V2.0 or higher
	;		VAX-11 RSX V1.1 or higher
	;
	/
