{ RPOIINFO.PAS - define control/status record for RPOI procedure.

  This file defines the control block required by the RPOI 
  external procedure. It assumes the definitions in
  EX:[22,320]GENERAL3.TYP. Certain bits within the control flags
  are defined in EX:[22,320]RPOI.CON. No constants are defined by
  this file. 

  FILE: EX:[22,320]RPOI.TYP
  AUTHOR: Jim Bostwick 13-Sep-84
  History: 
      JMB 13-Sep-84
  	  Copied with slight modification from P2UTIL module RPOIINFO.PAS

}
{ Number in parenthesis refers to following notes }

TYPE
  RPOI_Info_rec = Packed Record
    RPOI_Device:CH2;  { device requested task to run on (usually "TT")}
    RPOI_Unit:  Integer; {device number (octal) }
    RPOI_Group:	Integer; { Group number (octal) of UIC to run under (1)}
    RPOI_Member:Integer; { Member number (octal) of UIC to run under (1)}
    RPOI_RunName: Rad56; { Name requested task is to run under (2) }
    RPOI_Flags: Word;	 { control flags (3) }
    RPOI_Parent: Rad56;	 { name of parent task (4) }
    RPOI_POCB: Address;	 { address of parent OCB (4) }
    end;

{ NOTES:
    1.	Only a priveleged task OR a CLI may specify the UIC for the
    	requested task. If these are zero, the current UIC under which
    	the task issuing the RPOI is used.

    2.	The RPOI procedure has a TASK parameter, which specifies the
    	installed name of the requested task. For 'prototype' tasks
    	(i.e., ...foo), a CLI may specify an alternate name under
    	which the task will run (i.e., FOOT20 ) in the RPOI_RunName
    	field. If this field is null, the installed name will be
    	the run name. 

    3. The flags byte specifies several options, which may be 
    	ORed together:
    	RP.OEX = 200B   Force ISSUING task to exit on success of RPOI
        		     (Default is to return )
    	RP.OAL = 1	Pass all connections (from parent) to requested
    			task. (Not legal for CLIs - a CLI cannot pass all
  			of its connections to another task. )
    	RP.ONX = 2	Pass the first connection only, if there is one.

    	NOTE: RP.OEX is valid in all cases. RP.OAL and RP.ONX are mutually
    		exclusive, and are only meaningful if the issuing task
    		has itself been spawnned ( has a parent).

    4. It is possible to spawn a CLI (or other task) from an applications 
    	task. In this case, the CLI has a parent. The RPOI_Parent and
    	RPOI_POCB fields specify the name and OCB address to be passed
    	to the requested task. When this is done, the end result is
    	as if the parent had directly spawnned the offspring -- the
    	intermediate task (that issuing the RPOI) retains no knowlege
    	of or involvement in the offspring or the parent. The obvious
  	example is activating PIP via an RPOI to MCR...

}

    	
    	

