
{ 
  Version: 1.0
  File:[22,320]NET.TYP
  Author: Jim Bostwick 
  Last Edit: jmb -  1-JUN-1988 18:43:56

  History:
  
  This file contains DECnet definitions for OMSI Pascal-2.

}
{[a+,b+,l-,k+,r+] Pasmat }

{*USER*
There are two 'connect blocks' used by DECnet. The 
Net_request_block is used with outbound connections (e.g. calling
task initiates the link).  The Net_Connect_block is used for
inbound connections (e.g. calling program accepts the link). 
 Although DECnet-M-PLUS V4.0 supports both 'long' and 'short'
connect blocks, PASUTL only uses the 'long' form. 
}


CONST
    Net_Reqb_len = 76;  { Connect request block used with NTCON = 152. bytes }
    Net_Conb_len = 98;  { Connect block used with NTGND = 196. bytes }

TYPE 
    Net_Request_block = Array [1..Net_Reqb_len] of Word;
    Net_Connect_block = Array [1..Net_conb_len] of Word; 

{ DECnet IOSB codes. 

 These constants have been extracted from macro NSSYM$ in NETLIB.MLB.
They define various error and status codes. 

Names have been constructed as follows:
	1. Prefix all with "Net_".
	2. Convert embedded "." in MACRO symbol name to "_".

	Example:	VS.NPV --> Net_VS_NPV	(verified, non-priv user)

}

	{ Network Object Numbers }
Net_NO_TAS = 0B		{ General task, user process }
Net_NO_FA1 = 1B		{ File Access Listener (V1) }
Net_NO_TC1 = 5B		{ Task Control Listener (V1) }
Net_NO_TCL = 17B	{ Task Control Listener }
Net_NO_TLK = 20B	{ TALK utility }
Net_NO_FAL = 21B	{ File Access Listener }
Net_NO_RTL = 22B	{ Remote task loader }
Net_NO_NCU = 23B	{ Network control utility executor }
Net_NO_DTR = 77B	{ DECnet test receiver }

Net_NT_LCB = 1B		{ Long connect block } 

	{ Network Event Codes }
Net_NT_CON = 1B		{ Connect }
Net_NT_INT = 2B		{ Interrupt message }
Net_NT_DSC = 3B		{ User synchronous disconnect }
Net_NT_ABT = 4B		{ User abort }
Net_NT_ABO = 5B		{ Network abort }
Net_NT_EVT = 6B		{ Network event }
Net_NT_VFY = 7B		{ Network verification event }
Net_NT_MOP = 10B	{ MOP event }
Net_NT_NSP = 10B	{ NSP event (CCB only). same as NT.MOP }

	{ Verification Status }
Net_VS_NPV = 1B		{ Verified, non-privileged user }
Net_VS_PRV = 2B		{ Verified, privileged user }
Net_VZ_NVD = 0B		{ No verification performed }
Net_VE_FAI = -1	 	{ Verification failed }

{
	Phase III Session Control error reason codes returned
	with REJECT (REJ) or DISCONNECT (DSC)
}
Net_NE$RES = 1		{ Resource allocation failure (REJ) }
Net_NE$NOD = 2		{ Destination node name does not map to a 
			    node address (rej) }
Net_NE$NSR = 3		{ Remote node shutting down (REJ) }
Net_NE$UOB = 4		{ Destination process does not exist (REJ) }
Net_NE$FMT = 5		{ Invalid format for object specification (REJ) }
Net_NE$MLB = 6		{ Mailbox full for queuing message to object
	 		    or too many connects to object (REJ) }
Net_NE$ABM = 8	 	{ Link aborted by management (DSC) }
Net_NE$NNF = 10		{ Node name format error (REJ) }
Net_NE$NSL = 11		{ Local node shutting down (REJ) }
Net_NE$ACC = 34		{ Access not permitted - unacceptable 
				 RQSTRID / PASSWORD ETC.(REJ) }
Net_NE$ABO = 38 	{ No response from object (REJ/DSC) }
Net_NE$COM = 39 	{ Unable to communicate with node (REJ/DSC) }

	{ Standard RSX Error Codes }
{ 
	These error codes are standard RSX IOERR$ codes, with special
	meaning for DECnet. 
}
Net_IS_SUC = 1		{ Success }
Net_IS_DAO = 2		{ Success, but some data lost. }
Net_IE_BAD = -1		{ invalid buffer parameter, or data length > 16. }
Net_IE.SPC = -6		{ Invalid buffer parameters, buffer not word-aligned,
				illegal address space, buffer > 8128. words }
Net_IE.WLK = -12	{ Transmission of interrupt message before last one
				completed }
Net_IE.DAO = -13	{ Data overrun; unstored data was lost. }
Net_IE.ABO = -15	{ Link aborted or disconnected }
Net_IE.PRI = -16	{ Net not accessed on this LUN }
Net_IE.RSU = -17	{ Required system resources not available }
Net_IE.ALN = -34	{ Specified LUN already established. }
Net_IE.NLN = -37	{ No active link on Specified LUN }
Net_IE.URJ = -73	{ Remote task rejected connect attempt }
Net_IE.NRJ = -74	{ Network rejected connect attempt }
Net_IE.NDA = -78	{ There is no data available }
Net_IE.NNT = -94	{ The issuing task not a network tas; NTOPN not
			  executed successfully }
