Program mtest;

{
File		: DE:[22,310]MTEST.PAS
Author		: Peter Stadick
Date		: Aug 30,89
Edit History	:

       Last edit: 30-AUG-1989 15:04:49 

Description:

	This is the test program for memory arrays (MARRAY). It can also
	be used as an example for how to use the memory array package. This
	program shows how to access arrays thru a buffer or direct access
	thru a pointer. It also shows how access works when creating 
	multiple memory arrays accessed thru a single APR.

	The program allows you to enter the number of elements for all
	arrays and the element size of the first array. You can also determine
	if the first array is to use buffer access or pointer access. If you
	run multiple copies of this program on different TT:'s the arrays
	are shared.

}

%include lb:[22,320]general3.typ;
%include de:[22,320]marray.typ;

const
  ele_size2	= 11;
  ele_size3	= 79;

type
  ele_point	= ^ch30;

var
  apr_use_block	: apr_use_type;

  a1		: m_array_type;
  a2		: m_array_type;
  a3		: m_array_type;

  b1		: packed array [1..8192] of char;
  b2		: packed array [1..ele_size2] of char;
  b3		: packed array [1..ele_size3] of char;

  b_add1	: address;
  b_add2	: address;
  b_add3	: address;

  b_pnt		: ele_point;
  i,j		: integer;
  num_elements	: integer;
  ele_size1	: integer;

  another	: packed array [1..2] of char;
  point_it	: packed array [1..2] of char;
  mod_it	: packed array [1..2] of char;
  array_number	: packed array [1..2] of char;

  m_data	: packed array [1..80] of char;

%include de:[22,320]marray.ext;

begin
  minit(apr_use_block);
  writeln;
  write('Number of elements:');
  readln(num_elements);
  write('Element size (bytes):');
  readln(ele_size1);
  write('Use pointer:');
  readln(point_it);

  if (point_it[1] = 'Y') or (point_it[1] = 'y') then
  begin
    b_add1 := loophole(address,ref(b_pnt));
    mopen(a1,apr_use_block,5,'ARRAY1',num_elements,ele_size1,b_add1,true,
          true,i);
  end
  else
  begin
    b_add1 := loophole(address,ref(b1));
    mopen(a1,apr_use_block,5,'ARRAY1',num_elements,ele_size1,b_add1,false,
          true,i);
  end;
  writeln('error code ARRAY 1:',i);

  write('RBD:');
  for i := 1 to 8 do
    write(a1.rdb[i]:-8);
  writeln;
  write('WDB:');
  for i := 1 to 8 do
    write(a1.wdb[i]:-8);
  writeln;
  writeln('apr to use:',a1.apr_to_use);
  writeln('max_elements:',a1.max_elements);
  writeln('element_size:',a1.element_size);
  writeln('elements_per_window:',a1.elements_per_window);
  writeln('number_of_windows:',a1.number_of_windows);
  writeln('blocks_per_window:',a1.blocks_per_window);
  writeln('current_window:',a1.current_window);
  writeln('buffer_address:',a1.buffer_address:-8);

  b_add2 := loophole(address,ref(b2));
  mopen(a2,apr_use_block,5,'ARRAY2',num_elements,ele_size2,b_add2,false,true,i);
  writeln('error code ARRAY 2:',i);

  b_add3 := loophole(address,ref(b3));
  mopen(a3,apr_use_block,5,'ARRAY3',num_elements,ele_size3,b_add3,false,true,i);
  writeln('error code ARRAY 3:',i);
  
  if (point_it[1] = 'Y') or (point_it[1] = 'y') then
    writeln('Currently pointing to element number 1 for ARRAY 1.');

  repeat
    writeln;
    repeat
      write('Array to use (0 to exit):');
      readln(array_number);
    until (array_number[1] = '1') or (array_number[1] = '2') or
          (array_number[1] = '3') or (array_number[1] = '0');

    if not (array_number[1] = '0') then    
    repeat
      if ((point_it[1] = 'Y') or (point_it[1] = 'y')) and 
         (array_number[1] = '1') then
      begin
        write('Modify this element:');
        readln(mod_it);
 
        if (mod_it[1] = 'Y') or (mod_it[1] = 'y') then
        begin
          write('Enter data (max 30 characters):');
          readln(m_data);
          for j := 1 to 30 do
            b_pnt^[j] := m_data[j]
        end;
      end
      else
      begin
        write('Enter element number to put:');
        readln(i);
        write('Enter data (max 30 characters):');
        readln(m_data);
        case array_number[1] of
        '1' : begin
                for j := 1 to 30 do
                  b1[j] := m_data[j];
                mput(a1,i,j);
              end;
        '2' : begin
                for j := 1 to ele_size2 do
                  b2[j] := m_data[j];
                mput(a2,i,j);
              end;
        '3' : begin
                for j := 1 to ele_size3 do
                  b3[j] := m_data[j];
                mput(a3,i,j);
              end;
        end;
        writeln('Error code:',j);
      end;

      write('Enter element number to get:');
      readln(i);
      case array_number[1] of
      '1' : mget(a1,i,j);
      '2' : mget(a2,i,j);
      '3' : mget(a3,i,j);
      end;
      writeln('Error code:',j);
      write('Element data:');
      if ((point_it[1] = 'Y') or (point_it[1] = 'y')) and 
         (array_number[1] = '1') then
        for j := 1 to 30 do
          write(b_pnt^[j])
      else
        case array_number[1] of
        '1' : for i := 1 to 30 do
                write(b1[i]);
        '2' : for i := 1 to ele_size2 do
                write(b2[i]);
        '3' : for i := 1 to ele_size3 do
                write(b3[i]);
        end;
      writeln;

      write('Another:');
      readln(another);
    until (another[1] = 'N') or (another[1] = 'n');
  until array_number[1] = '0';
end.
