Program tstrpoi;

{ File: [22,311]TSTRPOI.PAS      Last edit: 23-MAY-1989 17:05:52 

  History:

    22-May-89.  Philip Hannay.  Created.


  Test the P3UTIL RPOI procedure.   Accepts a command line with
  the name of the task to rpoi, and a command line to use.
  Command line syntax
  is "xxxxxx ccccccccc...cccc" where xxxxxx is six task name (blank filled
  if need be) and cccc..ccc is variable length command line to give to
  the xxxxxx task when spawned.  A single space separates task name
  and command line.

}

{[A+,B+, K+, L-, R+] Pasmat Directive }

%include pas$ext:general.typ;
%include pas$ext:rpoi.typ;

%include pas$ext:rpoi.ext;
%include pas$ext:catr56.ext;  
%include pas$ext:stse.ext;

{ Use predefined pascal procedure GMCR to get MCR command line if any }
procedure GMCR;external;

{ Use predefined pascal procedure DETACH to detach TI: }
procedure DETACH;external;

Var
  task_name: ch6;
  rad_task_name: rad56;
  rpoi_info: rpoi_info_rec;
  dir_stat: integer;
  cmd_line: ch80;
  cmd_line_adr: word;
  cmd_len: integer;
  i: integer;

Begin
GMCR;
readln(cmd_line);
Writeln;
Writeln('Test RPOI procedure...');
Writeln;
for i:= 1 to 6 do task_name[i]:= cmd_line[i];
for i:= 8 to 80 do cmd_line[i-7]:= cmd_line[i];
for i:= 74 to 80 do cmd_line[i]:= ' ';
if cmd_line[1] = ' ' then cmd_len:= 0 else cmd_len:= 80;
detach;
catr56(task_name,rad_task_name);
writeln('  rpoi task "',task_name,'"');
cmd_line_adr:= loophole(word,ref(cmd_line));
{ init RPOI info block }
with rpoi_info do
  begin
  rpoi_device[1]:= chr(0);
  rpoi_device[2]:= chr(0);
  rpoi_unit:= 0;
  rpoi_group:= 0;
  rpoi_member:= 0;
  { rad50 name - indicate none with zero values }
  rpoi_runname[1]:= 0;
  rpoi_runname[2]:= 0;
  rpoi_flags:= 0;
  rpoi_parent[1]:= 0;
  rpoi_parent[2]:= 0;
  rpoi_pocb:= 0;
  end; {with}
{ signal that we want to pass all connections to offspring }
rpoi_info.rpoi_flags:= 1;
rpoi(rad_task_name,cmd_line_adr,cmd_len,rpoi_info);
dir_stat:= $dsw;
if dir_stat = 1
  then begin
    writeln('  rpoi done successfully, we will exit');
    end
  else begin
    writeln('  unable to rpoi task, $DSW = ',dir_stat:1);
    end;
writeln;
writeln('done with RPOI test');
writeln;
end.
