program tstqiow;

{ File: [122,11]TSTQIOW.PAS    Last edit: 8-MAY-1989 15:27:09 

  History:
    31-Jan-89.  Philip Hannay.  Created.
     4-May-89.  Philip Hannay.  Expanded to test SF.GMC/SF.SMC.
}

{ test program for QIOW.PAS routine }

%include pas$ext:general.typ;
%include pas$ext:direrr.ext;

%include pas$ext:qio.con;
%include pas$ext:qio.typ;
%include pas$ext:sf.typ;

%include pas$ext:qiow.ext;

type
  term_set_type = array [1..5] of terminal_characteristic_rec;

var
  inbuf, outbuf: ch40;
  par_list: qio_param_list;
  eio_list: eio_param_list;
  iostat: io_status_block;
  i, ids, lun: integer;
  foobar, lat: boolean;
  term_set: term_set_type;
  resp: char;

Begin
writeln('starting test');
writeln;

{ do a Write Logical Block }
writeln('output string "Hi there"');
writeln;
outbuf:= 'Hi there                                ';
par_list[1]:= loophole(word,ref(outbuf));
par_list[2]:= 20;
for i:=3 to 6 do par_list[i]:= 0;
qiow(io_wlb,5,f1,iostat,par_list);
foobar:= direrr('qiow failed',$dsw);
writeln('iostat is ',iostat.int[1]:1,',',iostat.int[2]:1);
writeln;

{ Do a Read Logical Block }
writeln('output done, now read 10 chars');
writeln;
par_list[1]:= loophole(word,ref(inbuf));
par_list[2]:= 10;
for i:=3 to 6 do par_list[i]:= 0;
qiow(io_rlb,5,f1,iostat,par_list);
foobar:= direrr('qiow failed',$dsw);
writeln('iostat is ',iostat.int[1]:1,',',iostat.int[2]:1);
writeln;
writeln('input done, it is ',inbuf);
writeln;

{ Do a Read Logical Block with no echo }
writeln('output done, now read 10 chars with no echo');
writeln;
par_list[1]:= loophole(word,ref(inbuf));
par_list[2]:= 10;
for i:=3 to 6 do par_list[i]:= 0;
qiow(io_rlb+tf_rne,5,f1,iostat,par_list);
foobar:= direrr('qiow failed',$dsw);
writeln('iostat is ',iostat.int[1]:1,',',iostat.int[2]:1);
writeln;
writeln('input done, it is ',inbuf);
writeln;

{ do a Read after Prompt }
writeln('read done, now read 10 chars after prompt');
writeln;
outbuf:= 'Enter value>                            ';
par_list[1]:= loophole(word,ref(inbuf));
par_list[2]:= 10;
par_list[3]:= 0;
par_list[4]:= loophole(word,ref(outbuf));
par_list[5]:= 13;
par_list[6]:= 0;
qiow(io_rpr,5,f1,iostat,par_list);
foobar:= direrr('qiow failed',$dsw);
writeln('iostat is ',iostat.int[1]:1,',',iostat.int[2]:1);
writeln;
writeln('input done, it is ',inbuf);
writeln;

{ do a Read after Prompt with 20 second timeout }
writeln('read done, now read 1 char after prompt with 20 sec timeout');
writeln;
outbuf:= 'Enter value>                            ';
par_list[1]:= loophole(word,ref(inbuf));
par_list[2]:= 1;
par_list[3]:= 2; { timeout = 2 * 10 secs }
par_list[4]:= loophole(word,ref(outbuf));
par_list[5]:= 13;
par_list[6]:= 0;
qiow(io_rpr+tf_tmo,5,f1,iostat,par_list);
foobar:= direrr('qiow failed',$dsw);
writeln('iostat is ',iostat.int[1]:1,',',iostat.int[2]:1);
writeln;
writeln('input done, it is ',inbuf[1]);
writeln;

{ read some terminal characteristics of TI: }
writeln('Now read some terminal characteristics of a terminal port');
writeln;
write('Enter lun associated with terminal (5 for TI:)> ');
readln(lun);
write('Is terminal a LAT terminal? (Y,N)> ');
readln(resp);
if resp in ['Y','y'] then lat:= true else lat:= false;
for i:= 1 to 5 do term_set[i].value:= 0;
term_set[1].id:= TC_PRI;  { priv }
term_set[2].id:= TC_TBS;  { type ahead size }
if lat
  then begin
    term_set[3].id:= TC_MAP;  { LAT application terminal }
    end
  else begin
    term_set[3].id:= TC_XSP;  { xmit speed }
    end;
term_set[4].id:= TC_HFF;  { formfeed }
term_set[5].id:= TC_TTP;  { term type }
par_list[1]:= loophole(word,ref(term_set));
par_list[2]:= 10; {bytes}
for i:= 3 to 6 do par_list[i]:= 0;
qiow(sf_gmc,lun,f1,iostat,par_list);
foobar:= direrr('qiow failed',$dsw);
writeln('iostat is ',iostat.int[1]:1,',',iostat.int[2]:1);
writeln;
if term_set[1].state = true
  then writeln('  Terminal is privileged')
  else writeln('  Terminal is not privileged');
writeln('  Terminal typeahead buffer is ',term_set[2].value:1);
if lat
  then begin
    if term_set[2].state = true
      then writeln('  Terminal is a LAT application port')
      else writeln('  Terminal is not a LAT application port');
    end
  else begin
    write('  Terminal Transmit speed is ');
    case term_set[3].speed of
      S_0: write('disabled');
      S_50: write('50 bps (baudot not supported)');
      S_75: write('75 bps');
      S_110: write('110 bps');
      S_134: write('134 bps');
      S_150: write('150 bps');
      S_200: write('200 bps');
      S_300: write('300 bps');
      S_600: write('600 bps');
      S_1200: write('1200 bps');
      S_1800: write('1800 bps');
      S_2000: write('2000 bps');
      S_2400: write('2400 bps');
      S_3600: write('3600 bps');
      S_4800: write('4800 bps');
      S_7200: write('7200 bps');
      S_9600: write('9600 bps');
      S_EXTA: write('DH11 external speed A');
      S_EXTB: write('DH11 external speed B');
      S_19_2: write('19200 bps');
      otherwise write('unknown');
      end; {case}
    writeln;
    end;
if term_set[4].state = true
  then writeln('  Terminal can do formfeeds')
  else writeln('  Terminal cannot do formfeeds');
write('  The terminal type is ');
  case term_set[5].value of
    0: write('unknown');
    3: write('ASR35');
    13: write('VT100');
    14: write('LA120');
    17: write('LA100');
    26: write('LA50');
    30: write('VT2XX');
    31: write('LN03');
    33: write('LA210');
    34: write('LQP03');
    35: write('LA75');
    otherwise write('unrecognized - ',ord(term_set[5].value):1);
    end; {case}
writeln;
writeln;
writeln;
writeln('end test');
end.
