Program TSTCRETAS;

{ Version 
  File:[22,311]TSTCretas.PAS
  Author: Phil Hannay.  22-Jun-89.
  Last Edit: 22-JUN-1989 13:47:14 
  History:


Testing P3UTIL module(s): cretas

}

{[a+,b+,l-,k+,r+] Pasmat }

%include pas$ext:general.typ;

%include pas$ext:string.pkg;
%include pas$ext:cretas.ext;


TYPE
  String = packed array [0..60] of char;
  bad_string = packed array [2..62] of char;

VAR
  r:real;
  i:integer;
  p:integer;
  d:integer;
  s:string;
  bs: bad_string;
  z:ch60;

Procedure doit;  {local}

begin
writeln;
writeln('real number ',r,' converts to ');
cretas(r,s,p,d);
if p = 0
  then begin
    { error }
    writeln('  <conversion error>');
    end
  else begin
    write('  "');
    swrite(output,s);
    writeln('" (pos is ',p:1,')');
    end;
writeln;
end;

Procedure doitz;  {local}

begin
writeln;
writeln('real number ',r,' converts to ');
cretas(r,z,p,d);
if p = 0
  then begin
    { error }
    writeln('  <conversion error>');
    end
  else begin
    write('  "');
    swrite(output,z);
    writeln('" (pos is ',p:1,')');
    end;
writeln;
end;

BEGIN
  writeln('Real to ascii conversion test');  
  writeln;
  writeln('First some standard tests');
  writeln;
  writeln('Using type1 strings...');
  writeln;
  r:= 345.678;
  writeln('Test real number is 345.678');
  writeln;
  writeln('Right justify, fill entire string, 6 decimal places');
  p:=0;
  d:=6;
  doitz;
  writeln('Right justify at position 20, 6 decimal places');
  p:=-20;
  doitz;
  writeln('Left justify at position 1, 6 decimal places');
  p:=1;
  doitz;
  writeln('Left justify at position 20, 6 decimal places');
  p:=20;
  doitz;
  writeln;
  writeln(' now with a negative number...');
  writeln;
  r:= -345.678;
  writeln('Test real number is -345.678');
  writeln;
  writeln('Right justify, fill entire string, 6 decimal places');
  p:=0;
  d:=6;
  doitz;
  writeln('Right justify at position 20, 6 decimal places');
  p:=-20;
  doitz;
  writeln('Left justify at position 1, 6 decimal places');
  p:=1;
  doitz;
  writeln('Left justify at position 20, 6 decimal places');
  p:=20;
  doitz;
  writeln;
  writeln('Right justify at position 20, no decimal places');
  p:= -20;
  d:= 0;
  doitz;
  writeln;
  writeln('Now with type0 string...');
  writeln;  
  r:= 345.678;
  writeln('Test real number is 345.678');
  writeln;
  writeln('Right justify, fill entire string, 6 decimal places');
  p:=0;
  d:=6;
  doit;
  writeln('Right justify at position 20, 6 decimal places');
  p:=-20;
  doit;
  writeln('Left justify at position 1, 6 decimal places');
  p:=1;
  doit;
  writeln('Left justify at position 20, 6 decimal places');
  p:=20;
  doit;
  writeln;
  writeln(' now with a negative number...');
  writeln;
  r:= -345.678;
  writeln('Test real number is -345.678');
  writeln;
  writeln('Right justify, fill entire string, 6 decimal places');
  p:=0;
  d:=6;
  doit;
  writeln('Right justify at position 20, 6 decimal places');
  p:=-20;
  doit;
  writeln('Left justify at position 1, 6 decimal places');
  p:=1;
  doit;
  writeln('Left justify at position 20, 6 decimal places');
  p:=20;
  doit;
  writeln;
  writeln('Right justify at position 20, no decimal places');
  p:= -20;
  d:= 0;
  doit;
  writeln;
  writeln('Now some bounds checking... ');
  writeln;
  writeln(' real = 123456789012345678901234567890123456789.01234567890');
  writeln;
  writeln(' result should have 6 (single) or 14 (double) digits of precision');
  r:= 123456789012345678901234567890123456789.01234567890;
  d:= 10;
  p:= 0;
  doit;
  writeln(' real = 0.1234567890123456789012345678901234567890');
  writeln;
  writeln(' result should have 6 (single) or 14 (double) digits of precision');
  r:= 0.1234567890123456789012345678901234567890;
  d:= 50;
  p:= 0;
  doit;
  writeln(' real = ',
     '0.00000000000000000001234567890123456789');
  writeln;
  writeln(' result should have 6 (single) or 14 (double) digits of precision');
  r:= 0.00000000000000000001234567890123456789;
  d:= 55;
  p:= 0;
  doit;
  writeln;
  writeln('Now some conversion errors');
  writeln;
  writeln('  Negative PLACE parameter, should get CRETAS diagnostic');
  r:= 345.678;
  p:=0;
  d:=-6;
  doit;
  writeln('  Bad POS parameter, should get CRETAS diagnostic');
  r:= 345.678;
  p:=80;
  d:=6;
  doit;
  writeln('  Non type0/type1 string, should get SLEN diagnostic');
  writeln('  POS should come back as 0 (conversion error)');
  r:= 345.678;
  p:=0;
  d:=6;
  cretas(r,bs,p,d);
  writeln('  pos = ',p:1,' (conversion error)');
  writeln;
  writeln('  String to small for conversion');
  r:= 345.678;
  p:=40;
  d:=40;
  doit;
  writeln;  
  writeln('Now you may enter your own real numbers, position and places');
  repeat
    writeln;
    write('  enter real number, position, place (999.0 to exit)> ');
    readln(r,p,d);
    if r <> 999.0 then doit;
  until r = 999.0;
  writeln;
  writeln('end of test.')
end.

      
