Program TSTCASTRE;

{ Version 
  File:[22,311]TSTCastre.PAS
  Author: Phil Hannay.  9-May-89.
  Last Edit: 14-AUG-1989 09:59:09 
  History:


Testing P3UTIL module(s): castre

}

{[a+,b+,l-,k+,r+] Pasmat }

%include pas$ext:general.typ;

%include pas$ext:string.pkg;
%include pas$ext:castre.ext;


TYPE
  String = packed array [0..80] of char;

VAR
  r:real;
  i:integer;
  p:integer;
  s:string;
  z:ch80;

Procedure doit;  {local}

begin
writeln;
write('in string is "');
swrite(output,s);
writeln('"');
writeln;
p := 1;
i := 0;
repeat
  i:= i+1;
  castre(s,r,p);
  if p < 0 
    then begin
      { overflow/underflow/syntax }
      writeln(i:1,'> overflow/underflow/syntax error');
      p:= -(p);
      end
    else begin
      writeln(i:1,'> ',r)
      end;
  p := p + 1; {skip terminator }
  until p >slen(s);
writeln;
end;

BEGIN
  writeln('ascii to real conversion test');  
  writeln;
  writeln('first some standard tests');
  writeln;
  writeln('You should see five conversions, all to 4.567000e+01 ');
  sassign(s,'  45.67  +45.67,+  45.67,45.670000!+000000045.67');
  doit;
  writeln('You should see two conversions, all to -4.560000e-01');
  sassign(s,'-0.456,-.456');
  doit;
  writeln('You should see five conversions, all to 4.500000e+01 ');
  sassign(s,'  45  +45;+  45;45.,+000000045');
  doit;
  writeln('You should one conversion, to 4.500000e+01 ');
  sassign(s,'  45');
  doit;
  writeln('You should one conversion, to 4.500200e+07 ');
  sassign(s,'  45,002,000');
  doit;
  writeln('You should see an error (overflow)');
  sassign(s,'34333333333333333333333333333333333333333333333.3334');
  doit;
  writeln('You should see an error (underflow), and 3.450000e+01');
  sassign(s,'0.00000000000000000000000000000000000000000000000032334,34.5');
  doit;
  writeln('You should see 3.450000e+01, 0.000000e+00, 2.345000e+01,');
  writeln('  0.000000e+00, 0.000000e+00, 8.900000e-01');
  sassign(s,'34.5,,23.45,,,.89');
  doit;
  writeln('You should see 0.000000e+00, 0.000000e+00, 0.0000000e+00');
  sassign(s,'abc');
  doit;
  writeln('You should see 0.000000e+00, 0.000000e+00, 0.0000000e+00');
  sassign(s,',,,');
  doit;
  writeln('You should see 3.452343e+05');
  sassign(s,'345,234.34');
  doit;
  writeln('You should see 2 errors (syntax), 0.000000+e00 (comma),');
  writeln('  5.234340e+03 - since incorrectly placed comma or omitted ');
  writeln('  decimal point will mess up interpretation until we hit ');
  writeln('  the "5" character.');
  sassign(s,'34,5,234.34');
  doit;
  writeln('You should see 3.450000e+01, 5.100000e+01, -9.200000e-01,');
  writeln('  8.100000e+01, and 2.300000e+00.');
  sassign(s,'34.5/51./-.92/81/2.3');
  doit;
  writeln('You should see 0.000000e+00');
  sassign(s,'0.0');
  doit;
  writeln('You should see 2.000000e+00');
  schassign(s,'2');
  doit;
  writeln('You should see 0.000000e+00');
  schassign(s,'.');
  doit;
  writeln('end of standard tests ');
  writeln;
  writeln('Now you may enter your own test strings');
  writeln;
  writeln('first we do type 0 strings (arrays)...');
  writeln('enter a line of numbers, separated by comma, tab, or space:');
  sread(input,s);
  { do while input string is not zero characters long }
  while s[0] <> chr(0) do 
    BEGIN 
    doit;
    writeln('enter a line of numbers, separated by comma, tab, or space:');
    sread(input,s)
    END;
  writeln;
  writeln('next we do type 1 strings (arrays)...');
  writeln('enter a line of numbers, separated by comma, tab, or space:');
  sread(input,z);
  while z[1] <> chr(0) do 
    BEGIN 
    p := 1;
    repeat
      castre(z,r,p);
      if p < 0 
        then begin
          { overflow }
          write ( 'overflow, ');
          p:= p * (-1);
          end
        else begin
          write(r,', ')
          end;
      p := p + 1; {skip terminator }
     until p > slen(z);
    writeln;
    writeln('enter a line of numbers, separated by comma, tab, or space:');
    sread(input,z);
    END;
  writeln('end of test.')
end.

      
