PROGRAM SRecv;

{ Intertask receive data for the String package.

  Version: 3.2
  File:[22,310]SRECV.PAS
  
  Last edit: 23-JUN-1988 22:29:34 

  History: 14-Apr-88.  Philip Hannay.  Created.
	   23-JUN-1988 21:59:13  - JMB PA3UTL upgrade.

}

{$NOMAIN}
{[A+,B+,L-,K+,R+] Pasmat Directive}

%include PAS$EXT:General.typ;

%include PAS$EXT:svassign.ext;
%include PAS$EXT:slen.ext;
%include PAS$EXT:sclear.ext;

%include PAS$EXT:vrcd.ext;
%include PAS$EXT:catr56.ext;
%include PAS$EXT:cr56ta.ext;


procedure SRecv(var dest: packed array [dlow..dhigh: integer] of char;
                var message: packed array [mlow..mhigh: integer] of char;
                var recv_status: integer
  	);External;

{*USER*
Receive a MESSAGE from the task specified in DEST.  If no task specified,
(string is clear - len = 0), then receive from any task.
The $DSW from variable receive directive is
returned in RECV_STATUS. }

Procedure SRecv;

type
  Packet_allocation_block = record
    rad56_task: rad56;
    message: packed array [1..512] of char;
    end;    

var
  PAB: Packet_allocation_block;
  bufadr: address;
  i, len, save_len: integer;
  task: ch6;

  begin {send string}
  if slen(dest) = 0
    then begin
      { no task specified, receive from any sender }
      sclear(task);
      end
    else begin
      { task specified, put in TASK. }
      svassign(task, dest);
      end;
  catr56(task, pab.rad56_task);
  bufadr:= loophole(address, ref(pab));
  VRCD(bufadr,256);
  recv_status:= $dsw;
  if recv_status >= 2
    then begin
      { successful receive, get the task name and message }
      cr56ta(pab.rad56_task, task);
      svassign(dest, task);
      len:= (recv_status - 2) * 2;
      save_len:= len;
      if mlow = 0
        then begin
          {type 0 string}
          if len > 255 then len:= 255;
          if len > mhigh then len:= mhigh;
          message[0]:= chr(len);
          for i:= 1 to len do message[i]:= pab.message[i];
          end
        else begin
          {type 1 string}
          if len > mhigh then len:= mhigh;
          for i:= 1 to len do message[i]:= pab.message[i];
          if len < mhigh 
            then for i:= len+1 to mhigh do pab.message[i]:= chr(0);
          end;
      if len <> save_len
        then begin
          { Caller supplied buffer is too small.  Indicate so in Recv_status
            with -15. IE.RBS.  However, we will have copied what we could
            into the caller supplied buffer. }
          Recv_status:= -15;
          end;
      end;
  end; { receive string } 

