{$DOUBLE}
Program REC1;

{ Version  X1.0
  File:[DECNET]REC1.PAS
  Author: Jim Bostwick 

  Last Edit: 17-FEB-1989 13:45:35 

  History:
;		 3-AUG-1989 10:50:29 - JMB - Add $DOUBLE switch


Testing P3UTIL module(s): various DECNET receiver modules.

}

{$nolist}
{[a+,b+,l-,k+,r+] Pasmat }
%INCLUDE 'PAS$EXT:GENERAL.TYP';
%INCLUDE 'PAS$EXT:DECNET.PKG';
%INCLUDE 'PAS$EXT:STRING.PKG';
%INCLUDE 'PAS$EXT:CLEF.EXT';
%INCLUDE 'PAS$EXT:SETF.EXT';
%INCLUDE 'PAS$EXT:STSE.EXT';
%INCLUDE 'PAS$EXT:ALUN.EXT';

{$list}


Const
	Nt_EFN = f33;	{ use to signal network activity }
	Aux_EFN = f34;	{ use for misc. things - esp to not trigger net 
			  active}
	Nt_Mbx_lun = 3; 	{ LUN for net data queue }
	Nt_Lun = 4;		{ LUN for net link }

VAR
    IOSB: IO_STATUS_BLOCK;
    RECISB: IO_STATUS_BLOCK;
    CONB: Net_Connect_block;
    A: Address; 		{ used for coercing IOSBs }
    BUFF: CH80;			{ buffer for received junk }
    Nul_Msg: CH16;			{ empty send message }
    Quit: Boolean;
    Dbg_DSW: Boolean; 		{ True to dump DSW values }

BEGIN
    Quit := False;    { hey! we only just got started...}
    DBG_DSW := TRUE; { dump DSW on syscalls... }
    Sclear(Nul_msg);

    { Assign LUNS for net queue and net link }

    Alun(Nt_Mbx_lun,'NS',0);
    IF Dbg_DSW THEN Writeln('$DSW=',$DSW:-8);
    Alun(Nt_lun,'NS',0);
    IF Dbg_DSW THEN Writeln('$DSW=',$DSW:-8);
    CLEF(Nt_Efn);	    { clear activity flag }
    IF Dbg_DSW THEN Writeln('$DSW=',$DSW:-8);
    Writeln('Call NTOPN to get a network LUN and start DECNET...');
    NtOpn(Nt_Mbx_lun,Aux_EFN,0,0,IOSB);
    IF Dbg_DSW THEN Writeln('$DSW=',$DSW:-8);
    Writeln('        done. IOSB[1]=',iosb.int[1]:-6,' IOSB[2]=',iosb.int[2]:-6);
       IF IOSB.int[1] = 1 THEN
	    BEGIN
    	    Writeln('Call NTSPA to set up net que notification...');
	    NtSPA(Nt_Mbx_lun,Nt_EFN,IOSB);
    	    IF Dbg_DSW THEN Writeln('$DSW=',$DSW:-8);
	    Writeln('        done. IOSB[1]=',iosb.int[1]:-6,' IOSB[2]=',iosb.int[2]:-6);
	    Writeln('   waiting for network activity...');
	    Repeat
		STSE(Nt_EFN);
    		IF Dbg_DSW THEN Writeln('$DSW=',$DSW:-8);
		CLEF(Nt_EFN);
		dbg_DSW := TRUE;
    		IF Dbg_DSW THEN Writeln('$DSW=',$DSW:-8);
		dbg_DSW := False;
		Writeln('Call NTGND to check network queue...');
		NTGND(Nt_Mbx_lun,Aux_Efn,Conb,IOSB);
    		IF Dbg_DSW THEN Writeln('$DSW=',$DSW:-8);
		Writeln('        done. IOSB[1]=',iosb.int[1]:-6,' IOSB[2]=',iosb.int[2]:-6);
		Writeln('IOSB[1] Lo = ',iosb.byt[1],' hi = ',iosb.byt[2],
			'IOSB[2] lo = ',iosb.byt[3],' hi = ',iosb.byt[4] );
  		IF (iosb.byt[1] = NT_IE_NDA) 
		    THEN Writeln('The queue is empty.')
		    ELSE CASE iosb.byt[2] of
			Nt_NT_CON :	{ Connect }
			    BEGIN
				Writeln('Call NTACC to accept network connect.');
				NTACC(Nt_Lun,Aux_EFN,Conb,Nul_msg,IOSB);
				Writeln('        done. IOSB[1]=',iosb.int[1]:-6,' IOSB[2]=',iosb.int[2]:-6);
			Writeln('Call NtREC to post no-wait receive...');
			NtRec(Nt_lun,Nt_EFN,loophole(address,ref(buff)),80,RecISB);
			IF Dbg_DSW THEN Writeln('$DSW=',$DSW:-8);
			Writeln('        done. RecISB[1]=',recisb.int[1]:-6,' RecISB[2]=',recisb.int[2]:-6);
				NtDCB(Conb)
			    END;
			Nt_NT_INT :	{ Interrupt message }
			    Writeln('Interrupt message, length = ',iosb.byt[3] ,' LUN = ',
			    	iosb.byt[4],'.');
			Nt_NT_DSC :	{ User synchronous disconnect }
			    BEGIN
				Writeln('Network Disconnect.');
				Quit := True
			    END;
			Nt_NT_ABT :	{ User abort }
			    BEGIN
				Writeln('Network User Abort.');
				Quit := True
			    END;
			Nt_NT_ABO :	{ Network abort }
			    BEGIN
				WRiteln('Network System Abort.');
				Quit := True
			    END;
			Otherwise Writeln('do something else');	
			END; {Case}
		IF NOT(Quit) THEN
		    IF (RecISB.int[1] <> 0) THEN
			BEGIN
			    Writeln('NTREC Completed. RecISB[1]=',recisb.int[1]:-6,
			    	' RecISB[2]=',recisb.int[2]:-6);
			    IF (RecISB.int[1] = 1) THEN
				BEGIN
			    	    Swrite(output,buff);
				    Writeln
				END;
			    Writeln('Call NtREC to post no-wait receive...');
			    NtRec(Nt_lun,Nt_EFN,loophole(address,ref(buff)),80,RecISB);
			    IF Dbg_DSW THEN Writeln('$DSW=',$DSW:-8);
			    Writeln('        done. RecISB[1]=',recisb.int[1]:-6,' RecISB[2]=',recisb.int[2]:-6);
			    Writeln('   waiting for network activity...')
			END;
	    UNTIL (QUIT);
	Writeln('end - Call NTCLS to close down net...');
	NtCLS(Nt_mbx_lun,Nt_efn,IOSB);
	Writeln('        done. IOSB[1]=',iosb.int[1]:-6,' IOSB[2]=',iosb.int[2]:-6)
	end
end.
