{
File		: DE:[22,320]MARRAY.TYP;
Author		: Peter Stadick
Date		: Aug 29,89
Edit History	:

       Last edit: 29-AUG-1989 21:55:12 

Description:

	The type declarations for memory arrays.
}

type
  rdb_type	= array [1..8] of integer;
  wdb_type	= array [1..8] of integer;
  apr_use_type	= array [1..7] of array [1..3] of integer;

  m_array_type 	= record
    rdb			: rdb_type;	{ Region descriptor block }
    wdb			: wdb_type;	{ Window descriptor block }
    apr_to_use		: integer;	{ APR number of window }
    max_elements	: integer;	{ Number of elements in array }
    element_size	: integer;	{ Size of an element in bytes }
    elements_per_window	: integer;	{ Number of elements in a window }
    number_of_windows	: integer;	{ Number of windows in region }
    blocks_per_window	: integer;	{ Number of 64 byte blocks per window }
    buffer_address	: integer;	{ Address of buffer }
    use_pointer		: boolean;	{ True if buffer is of pointer type }
    current_window	: integer;	{ Number of current window mapped }
    apr_use_address	: address;	{ Address of APR use block }
  end;
