{$NOLIST}
{ ******* PASCAL-3 *************}

{
 These are general type declarations that are commonly used in
Pascal programs regardless of the system in which the program
is to be used. This version is to conform to PASCAL-3 (V2.1)
standards. This involves the removal of certain specialized
types (they will now be defined in separate "packages"), and
the return of the BYTE type to type Char. 

FILE: LB:[22,320]GENERAL3.TYP (was GENTYP3.PAS)
AUTHOR: 24-Aug-83 Jim Bostwick 
History: This version created from GENTYP2.PAS 
  	9-sep-83 JMB - added $DSW definition
        2-oct-83 JMB - added $NOLIST/$LIST directives:
    			the default for this file is now NOLIST
  	7-Oct-83 JMB -- add global error class types
        19-Oct-83 PTH -- changed name of
                         this file to GENERAL3.TYP to conform to
                         our new include file naming specs.
  	20-Oct-83 JMB -- changed $DSW from WORD to INTEGER

Last Edit: 26-JAN-1987 15:45:29 
}
{*USER*

.HL 2 NAMES
 Unless there is a special reason to do otherwise (EFN is an
example), I have defined names with a leading Upper Case letter
followed by n lower case letters. I have made free use of the
underbar (_) for clarity. Note that most of the general types
have fairly long (and descriptive) names. 
I often include generic 'tag' identifiers, such as "_rec",
or "_type". This is done to a)distinguish type identifiers from
variable identifiers (i.e., Var Example:Example_rec); b) to try
to avoid general type identifiers which would logically be used
variable names.

.HL 2 Reserved names
 The following identifiers are reserved 
(primarily for the P2UTIL modules):
 DSW - pascal copy of $DSW
 IOSB - pascal copy of IO STATUS BLOCK (from QIOW calls). Type
 is IO_Status_Block 

Users are encouraged to use these standard identifiers whenever
possible.
        }

TYPE

{*USER* 
.HL 2 Character arrays. 
The following define packed arrays of various lengths.
The form is CHx, where x is the length. Lengths from 2 through
20 are defined, plus 26, and by tens from 30 through 80.
}

  CH1 = PACKED ARRAY [1..1] OF CHAR;
  CH2 = PACKED ARRAY [1..2] OF CHAR;
  CH3 = PACKED ARRAY [1..3] OF CHAR;
  CH4 = PACKED ARRAY [1..4] OF CHAR;
  CH5 = PACKED ARRAY [1..5] OF CHAR;
  CH6 = PACKED ARRAY [1..6] OF CHAR;
  CH7 = PACKED ARRAY [1..7] OF CHAR;
  CH8 = PACKED ARRAY [1..8] OF CHAR;
  CH9 = PACKED ARRAY [1..9] OF CHAR;
  CH10 = PACKED ARRAY [1..10] OF CHAR;
  CH11 = PACKED ARRAY [1..11] OF CHAR;
  CH12 = PACKED ARRAY [1..12] OF CHAR;
  CH13 = PACKED ARRAY [1..13] OF CHAR;
  CH14 = PACKED ARRAY [1..14] OF CHAR;
  CH15 = PACKED ARRAY [1..15] OF CHAR;
  CH16 = PACKED ARRAY [1..16] OF CHAR;
  CH17 = PACKED ARRAY [1..17] OF CHAR;
  CH18 = PACKED ARRAY [1..18] OF CHAR;
  CH19 = PACKED ARRAY [1..19] OF CHAR;
  CH20 = PACKED ARRAY [1..20] OF CHAR;
  CH26 = PACKED ARRAY [1..26] OF CHAR; { same size as a Send Data packet }
  CH30 = PACKED ARRAY [1..30] OF CHAR;
  CH40 = PACKED ARRAY [1..40] OF CHAR;
  CH50 = PACKED ARRAY [1..50] OF CHAR;
  CH60 = PACKED ARRAY [1..60] OF CHAR;
  CH70 = PACKED ARRAY [1..70] OF CHAR;
  CH80 = PACKED ARRAY [1..80] OF CHAR;

{*USER*
.hl 2 Radix-50 
 The following types define RAD-50 data. Note that Pascal does not 
understand Rad50, and that these are really only usefull for system 
interface uses. Type Rad56 is very usefull for holding task names. 
}

  Rad53 = INTEGER; { 3 character Rad50 }
  Rad56 = Array [1..2] of Rad53; { 6-character Rad50 }

{*USER*
.hl 2 General BYTE and WORD types. 
 These are usually used for low-level interface, and
also with LOOPHOLE for some external procedures which formerly used 
deliberately mis-matched parameters. 
In keeping with Pascal typing practice, WORD, Unsigned_Integer, and 
Address are all defined. Usage of word and Unsigned_Integer is 
generally similar. 
 The BYTE data type has had a long and troubled history with OMSI 
Pascal. The current usage defines BYTE as CHAR. This allows true
8-bit byte values to be manipulated. To get to and from a numeric 
value, use ORD and CHR.
}

  WORD = 0..65535; { PDP word }
  Unsigned_Integer = WORD;
  Address = WORD;
  BYTE = Char; { PDP BYTE. Use ORD and CHR for numeric values. }

{*USER*
.hl 2 Time Units.
 The Time_Unit type is used in library calls involving time span 
or delay (i.e., WAIT, MRKT). It comprises Ticks (60 ticks per second),
seconds, minutes, and hours. 
}

  Time_Unit = (ticks, seconds, minutes, hours);

{*USER*
.hl 2 Date and Time records
 These define ASCII and Integer records containing the
full date/time information, to the second. (Ticks are something one
finds only on dogs.)  Subrecords are defined, which allows the entire
date or time to be referenced as a unit.
The integer records have intentionally left as INTEGER, rather than
subrange types. This allows an illegal date/time to be read into 
the record, and then validated, without a run-time error.
 The ASCII date and time library procedures are now very flexible in 
the amount of information returned. They key on the length of the 
input array, and return just what is requested. 
}

TYPE
  Int_Date =
    RECORD
      Year: Integer; {00-99}
      Month: Integer; {01-12}
      Day: Integer; {01-31}
    end;

  Int_Time =
    RECORD
      Hour: Integer; {00-23}
      Minute: Integer; {00-59}
      Second: Integer; {00-59}
    end;

  Int_Timestamp =
    RECORD
      Date: Int_Date;
      Time: Int_Time;
    end;

        { AGAIN, this time in ASCII...
          note that these are NOT record types -- they are simple
          character arrays, defined more for convenience than anything
          else.
        }

  DEC_Date = ch9;
  DEC_Time = ch8;
  DEC_Timestamp = CH18;

  {End of date/time types }

{*USER*
.hl 2 EVENT FLAGS
 Event flags are defined as a scalar type. 
Note that all EFNs are defined, including those 'reserved' by DEC.
A null value, f0, is defined as well.
The identifier EFN is reserved for use as a type Event_Flag, especially
within the utility library modules. 
 While not an efn, a flag of zero (f0) acts as a wildcard for some 
calls. CMKT (cancel marktime), for example, will cancel ALL marktimes 
if called with efn of zero. Secondary benefit is that ORD(EFN) is 
equal to the flag number. 
 EFNs f25-f32 and f57-f64 are reserved by DEC. Use them at your own 
risk (it won't crash the system, but your task may act strangely). 
 A drawback of this approach is that the Pascal flag-set and
the DEC mask words do not line up. This is normally transparent 
to the user. It is of critical importance to implementors of 
library procedures, however.

.hl 2 GROUP GLOBAL SUPPORT
 P3UTIL NOW SUPPORTS GROUP GLOBAL EVENT FLAGS !!!
 This has been done primarily because DEC now supports Group Globals
in all of its calls. Also, we have been running into more conflicts
in event flag usage. New projects are highly encouraged to employ
group globals rather than system globals. This change
makes the event flag structures larger, but this should be transparent
to all users. 
 Note that group global efns must be created before they can be used.
See the CRGF procedure. 
}

TYPE
  {[F-]}
        Event_Flag =(
           f0, {NOT an event flag, but usefull for some calls }
     f1, f2, f3, f4, f5, f6, f7, f8, f9,f10,f11,f12,f13,f14,f15,f16 {group #0},
    f17,f18,f19,f20,f21,f22,f23,f24,f25,f26,f27,f28,f29,f30,f31,f32 {group #1},
    f33,f34,f35,f36,f37,f38,f39,f40,f41,f42,f43,f44,f45,f46,f47,f48 {group #2},
    f49,f50,f51,f52,f53,f54,f55,f56,f57,f58,f59,f60,f61,f62,f63,f64 {group #3},
    f65,f66,f67,f68,f69,f70,f71,f72,f73,f74,f75,f76,f77,f78,f79,f80 {group #4},
    f81,f82,f83,f84,f85,f86,f87,f88,f89,f90,f91,f92,f93,f94,f95,f96 {group #5}
    );

{[F+]}
        { Group numbers are usefull for logical OR of event flag calls. 

         The above works nicely, but fouls up SET of FLAG, because there is an
         extra element (f0). So, the two sets below are defined in terms of a 
         subrange of Event_Flag. I don't think that this will cause users any
         troubles. 
        }

{*USER*
.hl 2 Event Flag Sets
 To structures are defined for use with event flags. The Event_Flag_Set
is simply a set of all real event flags (f0 is not included). 
This type is returned by the RDAF procedure. The
Event_Flag_Array is a packed array of boolean which will match up
with Event_Flag_Set. The ability to swap between these two types 
(using Loophole) is often usefull. 
}

  Event_Flag_Set = PACKED SET OF f1..f96;
  Event_Flag_Array = Packed Array [f1..f96] of BOOLEAN;
                  { this may or may not prove a useful type. LOOPHOLE 
                  will nicely swap Event_Flag_SET and Event_Flag_Array types.}

{*USER*
.hl 2 IO Status Block
 The IO_Status_Block type is used with all library procedures which 
do IO. Its contents are defined in the IO DRIVERS REFERENCE MANUAL. 
}

  IO_Status_Block = Array [1..2] Of INTEGER; { Used with QIO procedures }

{*USER*
.hl 2 Error Class
 The P3UTIL procedure ERROR takes a severity class. Fatal errors cause
program termination (with exit status), while other classes do not.
}
  Error_class = (fatal_err, warning_err);

{*USER*
.hl 2 Directive Status Word
 In previous libraries, the executive calls included a Var parameter
DSW, which received a copy of the task's directive status word. 
This method has been replaced by a GLOBAL variable $DSW. $DSW is 
origined to the task $DSW (in the low core context area of each task). 
Thus, the DSW parameter no longer appears in the executive directive
procedures. The user should continue to check $DSW after each procedure
call which invokes an exec directive. 
}

VAR
  $DSW ORIGIN 46B :Integer;  { Define the task Directive Status Word }


{$LIST}
