program latorg;


{
File		: DE:[7,11]LATORG.PAS
Author		: Peter Stadick
Date		: Sept 19,89
Edit History	:

       Last Edit: 20-SEP-1989 10:18:35 

Description:

  This program allows you to do a general explicit connection to a LAT port.

}
%include lb:[22,320]general3.typ;

const
  debug	= false;
  use_command_line = true;

var
  device	: ch2;
  dev_number	: integer;
  number	: ch2;
  server	: ch16;
  port		: ch16;
  iosb		: io_status_block;
  low_byte	: integer;
  high_byte	: integer;
  all_ok	: boolean;
  do_connect	: boolean;
  dsw		: integer;
  command_buffer: ch80;
  command_length: integer;
  ch		: char;
  i		: integer;
  pos		: integer;

%include lb:[22,320]alun.ext;
%include de:[22,320]qioatt.ext;
%include de:[22,320]latdis.ext;
%include de:[22,320]latcon.ext;
%include de:[22,320]latset.ext;
procedure gmcr; external;

procedure do_help;

begin
  writeln('ORG allows you to originate a connection to a LAT port.');
  writeln('Three types of command operations are available:');
  writeln('-Assign server and port name to a applications terminal and connect');
  writeln(' ORG TT**:=server name,port name');
  writeln('-Connect to a terminal that has the server and port name already set');
  writeln(' ORG TT**:');
  writeln('-Disconnect an applications terminal');
  writeln(' ORG TT**:/D');
  writeln('This is a privilged (PR:0) task');
end; { do help }

begin
  if use_command_line then
  begin
    gmcr;
    all_ok := true;
    command_length := 0;
    for i := 1 to 80 do
      command_buffer[i] := ' ';
    while not eoln do
    begin
      command_length := command_length + 1;
      read(ch);
      command_buffer[command_length] := ch;
    end;

    if debug then
    begin
      writeln('Command length:',command_length);
      for i := 1 to command_length do
        write(command_buffer[i]);
      writeln;
    end;

    if command_length = 3 then
    begin
      do_help;
      all_ok := false;
    end
    else
    begin
      device[1] := command_buffer[5];
      device[2] := command_buffer[6];

      { next character must be a digit or ':' }
      if not (((command_buffer[7] >= '0') and (command_buffer[7] <= '9')) or
         (command_buffer[7] = ':')) then
      begin
        all_ok := false;
        writeln('invalid device number');
      end;

      if all_ok then
      begin
        pos := 7;
        number := '00';
        if (command_buffer[7] >= '0') and (command_buffer[7] <= '9') then
        begin
          number[2] := command_buffer[7];
          pos := 8;
          if (command_buffer[8] >= '0') and (command_buffer[8] <= '9') then
          begin
            number[1] := number[2];
            number[2] := command_buffer[8];
            pos := 9;
          end;
        end;

        dev_number := ((ord(number[1]) - ord('0')) * 8)  +
          (ord(number[2]) - ord('0'));

        { next position must be a colon }
        if not (command_buffer[pos] = ':') then
        begin
          all_ok := false;
          writeln('Missing colon after device');
        end;

        if command_length < pos then
        begin
          all_ok := false;
          writeln('Command to short');
        end;
      end;

      if all_ok then
      begin
        server := '                ';
        port := '                ';
        pos := pos + 1;
        all_ok := false;

        { this postion must me a '=',' ', or '/' }
        if not ((command_buffer[pos] = ' ') or (command_buffer[pos] = '=') or
                (command_buffer[pos] = '/')) then
          writeln('Invalid switch or =');

        if command_buffer[pos] = ' ' then
        begin
          { appears we only what to do a vanilla connect but lets check
            that the rest of the command if blank }
          all_ok := true;
          for i := pos to command_length do
            if not (command_buffer[i] = ' ') then
              all_ok := false;
          if not all_ok then
            writeln('Garbage at end of command');
        end;

        { See if is a switch to disconnect only }
        do_connect := true;
        if command_buffer[pos] = '/' then
        begin
          if command_buffer[pos+1] = 'D' then
          begin
            do_connect := false;
            all_ok := true;
          end
          else
            writeln('Invalid switch');
        end;

        { Check for server and port names preceeded by '=' }
        if command_buffer[pos] = '=' then
        begin
          { lets get server name }
          pos := pos + 1;
          i := 1;
          while (pos <= command_length) and (i <= 16) and
                not (command_buffer[pos] = ',') do
          begin
            server[i] := command_buffer[pos];
            pos := pos + 1;
            i := i + 1;
          end;

          { must have a comma }
          if command_buffer[pos] = ',' then
          begin
            pos := pos + 1;
            i := 1;
            while (pos <= command_length) and (i <= 16) do
            begin
              port[i] := command_buffer[pos];
              pos := pos + 1;
              i := i + 1;
            end;
            all_ok := true;
          end
          else
            writeln('Missing comma');
        end;
      end;

      if not all_ok then
        writeln('ORG -- command syntax error');

      if debug then
      begin
        writeln('Device:',device,':');
        writeln('Number:',dev_number);
        writeln('Server:',server,':');
        writeln('Port:',port,':');
        if do_connect then
          writeln('Do connect')
        else
          writeln('DISCONNECT');
      end;
    end;
  end
  else
  begin
    write('Device:');
    readln(device);
    write('Device number:');
    readln(dev_number);
    write('Server:');
    readln(server);
    write('Port:');
    readln(port);
    do_connect := true;
  end;

  { Assign the lun }
  if all_ok then
  begin
    alun(1,device,dev_number);
    dsw := $dsw;
    if dsw < 0 then
    begin
      all_ok := false;
      writeln('ORG -- error assigning lun. $DSW:',dsw);
    end;
  end;

  { Attach lun }
  if all_ok then
  begin
    qioatt(1,f2);
    dsw := $dsw;
    if dsw < 0 then
    begin
      all_ok := false;
      writeln('ORG -- error attaching lun. $DSW:',dsw);
    end;
  end;
  
  { Disconnect old assignment }
  if all_ok then
  begin
    latdis(1,f2);
    dsw := $dsw;
    if dsw < 0 then
    begin
      all_ok := false;
      writeln('ORG -- error in disconnecting. $DSW:',dsw);
    end;
  end;    

  { Reattach lun }  
  if all_ok then
  begin
    qioatt(1,f2);
    dsw := $dsw;
    if dsw < 0 then
    begin
      all_ok := false;
      writeln('ORG -- error in reattaching. $DSW:',dsw);
    end;
  end;
  
  { Set connection parameters }
  if all_ok and 
     not ((server = '                ') or (port = '                ')) then
  begin
    latset(1,server,port,f2);
    dsw := $dsw;
    if debug then
      writeln('LATSET $dsw:',$dsw);
    if dsw < 0 then
    begin
      all_ok := false;
      writeln('ORG -- error in setting server and port name. $DSW:',dsw);
    end;
  end;

  { Do the connection }
  if all_ok and do_connect then
  begin
    latcon(1,f2,iosb);
    dsw := $dsw;
    low_byte := iosb[1] mod 256;
    high_byte := iosb[1] div 256;
    if debug then 
      writeln('LATCON $dsw:',$dsw,'IOSB[1]:',high_byte,low_byte,'IOSB[2]:',
        iosb[2]);
    if dsw < 0 then
      writeln('ORG -- IO.ORG $DSW error :',dsw)
    else
    begin
      if low_byte > 1 then
        writeln('ORG -- Could not connect. Error number:',low_byte);
      if low_byte < 0 then
        case low_byte of
        -17 : writeln('ORG -- Port busy (IE.RSU)');
        -3  : begin
                writeln('ORG -- Device not ready (IE.DNR).');
                case high_byte of
                0   : writeln('Server or app terminal not available');
                -16 : writeln('IE.PRI - access list error');
                -47 : writeln('IE.ICE - internal corruption error');
                -74 : writeln('IE.NRJ - service busy');
                -81 : writeln('IE.FLN - terminal server service disabled');
                -96 : writeln('IE.CNR - not LAT app terminal. Is server port set',
                              ' remote?');
                -97 : writeln('IE.UKN - port or service does not exist');
                -102: writeln('IE.IRR - Insufficient server resources');
                otherwise writeln('ORG -- Unknown error:',high_byte);
                end;
              end;
        otherwise writeln('ORG -- Unknown error:',low_byte);
        end;
    end;
  end;
end.
