{ File: [22,311]TSTUNSLCT.PAS        Last edit: 30-MAY-1989 17:31:50 

PROGRAM TSTUNSLCT;

{ UNSLCT unsolicated input AST P3UTIL library procedure test program.
Uses Pascal predefined DETACH external, plus P3UTIL routines STLO, 
CLEF, WAIT and RDEF.

}

%include pas$ext:general.typ;

%include pas$ext:stlo.ext;
%include pas$ext:clef.ext;
%include pas$ext:rdef.ext;
%include pas$ext:wait.ext;
%include pas$ext:typbuf.ext;
%include pas$ext:unslct.ext;


VAR
  count, status: integer;
  resp: ch20;
  dev1name, dev2name: ch5;
  dev1, dev2: text;

BEGIN
writeln;
writeln('Begin test of UNSLCT and TYPBUF routines...');
writeln;
write('Enter device 1 to listen to (ttnn:)> ');
readln(dev1name);
write('Enter device 2 to listen to (ttnn:)> ');
readln(dev2name);
writeln;
writeln('Opening files to the devices "',DEV1NAME,'" and "',DEV2NAME,'"');
reset(dev1,dev1name,,status);
writeln('Status for ',dev1name,' is ',STATUS:1);
reset(dev2,dev2name,,status);
writeln('Status for ',dev2name,' is ',STATUS:1);
writeln;
{We will test out the error conditions of UNSLCT.  The flag must be
 a valid efn, so compiler will weed out any incorrect values.  The
 lun must be between 1 and 30 inclusive.}
writeln;
writeln('Try attach of invalid luns (not between 1-30 inclusive),');
writeln('  should result in status of -96 (IE.ILU) invalid lun');
writeln;
WRITELN('Attach devices with unsolicited input notification');
UNSLCT(0,f33,STATUS);
WRITELN('Status for ',dev1name,' attach (lun 0) is ',STATUS:1);
UNSLCT(-3,f33,STATUS);
WRITELN('Status for ',dev1name,' attach (lun -3) is ',STATUS:1);
UNSLCT(31,f33,STATUS);
WRITELN('Status for ',dev1name,' attach (lun 31) is ',STATUS:1);
writeln;
writeln('Try "attach" of ',dev1name,' (lun 1) using F0 event flag.  This ');
writeln('  should actually detach lun 1 as F0 is the null efn.  Status ');
writeln('  returned should be success (1)');
writeln;
unslct(1,f0,status);
writeln('Status for ',dev1name,' attach (detach - flag 0) is ',STATUS:1);
writeln;
writeln;
writeln('Now attach ',dev1name,' (lun 1) and ',dev2name,' (lun 2) using ');
writeln('  event flags 33 and 34.  The attaches should be successful,');
writeln('  and the devices attached for unsolicted input ASTs.');
writeln;
{Attach DEV1 and DEV2 and connect to different global flags for
 selective detection.  Also do DEV1 twice, to insure that last attach
 wins, and that there is no error if device already attached. }
unslct(1,f35,status);
writeln('Status for ',dev1name,' attach (flag 35) is ',STATUS:1);
unslct(1,f33,status);
writeln('Status for ',dev1name,' attach (flag 33) is ',STATUS:1);
unslct(2,f34,status);
writeln('Status for ',dev2name,' attach (flag 34) is ',STATUS:1);
writeln;
writeln('Now try some invalid TYPBUF calls.  First two calls to');
writeln('  invalid luns 16 and -3 should give a -96 (IE.ILU), and the');
writeln('  third call should give a -7 (IE.DNA) as the device is');
writeln('  not attached, but does not, as it returns a 0 count');
writeln;
count:= typbuf(16);
writeln('Typeahead count for lun 16 is ',count:1);
count:= typbuf(-3);
writeln('Typeahead count for lun -3 is ',count:1);
count:= typbuf(3);
writeln('Typeahead count for lun 3 is ',count:1);
writeln;
writeln('Now we enter a loop that waits for input from either');
writeln('  attached devices ',DEV1NAME,' or ',DEV2NAME,'.  When input');
writeln('  is detected, the typeahead buffer count will be returned,');
writeln('  along with the results of the readln');
writeln;
repeat
  {Cycle in an endless loop until one of the DEVs enters an "X" in the
   first character position.  }
  writeln;
  writeln('waiting for input...');
  stlo([f33,f34]);
  if rdef(f33)
    then begin
      clef(f33);
      writeln('input started, waiting 5 secs before reading');
      wait(f1,5,seconds);
      count:= typbuf(1);
      readln(dev1,resp);
      writeln;
      writeln(' Input (',count:1,' bytes)on ',
           dev1name,' (lun 1) is "',resp,'"');
      end;
  if rdef(f34)
    then begin
      clef(f34);
      writeln('input started, waiting 5 secs before reading');
      wait(f1,5,seconds);
      count:= typbuf(2);
      readln(dev2,resp);
      writeln;
      writeln(' Input (',count:1,' bytes)on ',
           dev2name,' (lun 2) is "',resp,'"');
      writeln;
      end;
  until (resp[1] in ['X','x']);
writeln;
writeln('end of UNSLCT/TYPBUF test');
writeln;
end.
