PROGRAM TSTSTLO;

{ File: TSTSTLO.PAS      Last edit: 9-MAY-1989 15:01:40 

  History:

     23-Oct-87.  Philip Hannay.  Created.
     09-May-89.  Philip Hannay.  Updated to use GENERAL.TYP, logicals

 }

{ This program will test the STLO P3UTIL module, requires the CLEF and
  MRKT directives. }

%INCLUDE PAS$EXT:GENERAL.TYP;

%INCLUDE PAS$EXT:CLEF.EXT;
%INCLUDE PAS$EXT:MRKT.EXT;

%INCLUDE PAS$EXT:STLO.EXT;

Var
  i: integer;
  resp: char;


Procedure Do_test;

begin
clef(f35);
clef(f36);
clef(f38);
mrkt(f36,10,seconds);
writeln;
writeln('STLO for F35, F36, F38 - f36 will set in 10 seconds');
STLO([f35,f36,f38]);
i:=$dsw;
writeln('STLO exited, $dsw (octal) is ',i:1);
writeln;
writeln('STLO for F15, F33, F36 - an invalid set specifying two groups');
STLO([F15,F33,F36]);
i:=$dsw;
writeln('STLO exited, $dsw (octal) is ',i:1);
writeln;
writeln('STLO for no flags - an invalid set (null) specifying no flags');
STLO([]);
i:=$dsw;
writeln('STLO exited, $dsw (octal) is ',i:1);
writeln;
clef(f67);
clef(f69);
mrkt(f69,10,seconds);
writeln('Group globals - try with group globals created, and without');
writeln('STLO for F67, F69 - a set of group global flags - f69 set in 10 secs');
STLO([F67,F69]);
i:=$dsw;
writeln('STLO exited, $dsw (octal) is ',i:1);
writeln;
clef(f33);
clef(f48);
mrkt(f48,10,seconds);
writeln('STLO for F33, F48 - upper/lower limits on a group - f48 set in ',
  '10 secs');
STLO([F33,F48]);
i:=$dsw;
writeln('STLO exited, $dsw (octal) is ',i:1);
writeln;
clef(f96);
mrkt(f96,10,seconds);
writeln('STLO for F96 - one flag, upper limit of set - f96 set in 10 secs');
STLO([F96]);
i:=$dsw;
writeln('STLO exited, $dsw (octal) is ',i:1);
writeln;
clef(f1);
mrkt(f1,10,seconds);
writeln('STLO for F1 - one flag, lower limit of set - f1 set in 10 secs');
STLO([F1]);
i:=$dsw;
writeln('STLO exited, $dsw (octal) is ',i:1);
writeln;
end;

Begin
writeln('Begin STLO test');
writeln;
writeln(' Flags 1,33,35,36,38,48,67,69,96 will be cleared in process.');
writeln(' Flags 1,36,48,69,96 will be set in the process.');
writeln(' Group global flags will work only if they have been created.');
writeln(' Test with and without group global flags.  The STLO will');
writeln(' be performed with valid flag sets, and a marktime will set');
writeln(' one of the flags in the set after a 10 second wait.');
writeln;
write('Ready to go on (flags will clear and set)? (Y,N)> ');
readln(resp);
if (resp = 'Y') or (resp = 'y') then do_test;
writeln;
writeln('End STLO test');
end.
