{ File: [22,311]TSTSLEN.PAS     Last edit: 9-MAY-1989 17:55:49 

  History:  Philip Hannay  21-Apr-88.  Created.

}

Program TSTSLEN;

%include pas$ext:general.typ;

%include pas$ext:slen.ext;

Var
  asc: packed array [0..80] of char;
  asc1: ch80;
  asc2: packed array [5..35] of char;
  asc3: packed array [0..500] of char;
  asc4: packed array [1..500] of char;
  asc5: packed array [0..255] of char;
  i, len: integer;

Begin
Writeln('Begin SLEN test');
Writeln;
Writeln('First test with non intialized strings');

len:= slen(asc);
writeln(' with string 0..80, len = ',len:1);
writeln('  (should be len = 0..255)');
writeln;

len:= slen(asc5);
writeln(' with string 0..255, len = ',len:1);
writeln('  (should be len = 0..255)');
writeln;

len:= slen(asc1);
writeln(' with string 1..80, len = ',len:1);
writeln('  (should be len = 0..80)');
writeln;

len:= slen(asc4);
writeln(' with string 1..500, len = ',len:1);
writeln('  (should be len = 0..500)');
writeln;

writeln('Next test with initialized strings');
writeln;

asc[0]:= chr(48);
len:= slen(asc);
writeln(' with string 0..80, len = ',len:1);
writeln('  (should be len = 48)');
writeln;

asc[0]:= chr(0);
len:= slen(asc);
writeln(' with string 0..80, len = ',len:1);
writeln('  (should be len = 0)');
writeln;

asc[0]:= chr(80);
len:= slen(asc);
writeln(' with string 0..80, len = ',len:1);
writeln('  (should be len = 80)');
writeln;

asc5[0]:= chr(223);
len:= slen(asc5);
writeln(' with string 0..255, len = ',len:1);
writeln('  (should be len = 223)');
writeln;

asc5[0]:= chr(255);
len:= slen(asc5);
writeln(' with string 0..255, len = ',len:1);
writeln('  (should be len = 255)');
writeln;

for i:=1 to 80 do asc1[i]:= chr(0);
len:= slen(asc1);
writeln(' with string 1..80, len = ',len:1);
writeln('  (should be len = 0)');
writeln;

for i:=1 to 42 do asc1[i]:= chr(68);
for i:= 43 to 80 do asc1[i]:= chr(0);
len:= slen(asc1);
writeln(' with string 1..80, len = ',len:1);
writeln('  (should be len = 42)');
writeln;

for i:=1 to 64 do asc1[i]:= chr(0);
asc1[65]:= chr(68);
for i:= 66 to 80 do asc1[i]:= chr(0);
len:= slen(asc1);
writeln(' with string 1..80, len = ',len:1);
writeln('  (should be len = 65)');
writeln;

for i:=1 to 79 do asc1[i]:= chr(68);
asc1[80]:= chr(0);
len:= slen(asc1);
writeln(' with string 1..80, len = ',len:1);
writeln('  (should be len = 79)');
writeln;

for i:=1 to 80 do asc1[i]:= chr(68);
len:= slen(asc1);
writeln(' with string 1..80, len = ',len:1);
writeln('  (should be len = 80)');
writeln;

for i:=1 to 500 do asc4[i]:= chr(0);
len:= slen(asc4);
writeln(' with string 1..500, len = ',len:1);
writeln('  (should be len = 0)');
writeln;

for i:=1 to 342 do asc4[i]:= chr(68);
for i:= 343 to 500 do asc4[i]:= chr(0);
len:= slen(asc4);
writeln(' with string 1..500, len = ',len:1);
writeln('  (should be len = 342)');
writeln;

for i:=1 to 264 do asc4[i]:= chr(0);
asc4[265]:= chr(68);
for i:= 266 to 500 do asc4[i]:= chr(0);
len:= slen(asc4);
writeln(' with string 1..500, len = ',len:1);
writeln('  (should be len = 265)');
writeln;

for i:=1 to 499 do asc4[i]:= chr(68);
asc4[500]:= chr(0);
len:= slen(asc4);
writeln(' with string 1..500, len = ',len:1);
writeln('  (should be len = 499)');
writeln;

for i:=1 to 500 do asc4[i]:= chr(68);
len:= slen(asc4);
writeln(' with string 1..500, len = ',len:1);
writeln('  (should be len = 500)');
writeln;

Writeln('Now some error conditions...');
writeln;

asc[0]:= chr(81);
len:= slen(asc);
writeln(' with string 0..80, len byte = 81, len = ',len:1);
writeln('  (should be warning and len = 0)');
writeln;

asc[0]:= chr(221);
len:= slen(asc);
writeln(' with string 0..80, len byte = 221, len = ',len:1);
writeln('  (should be warning and len = 0)');
writeln;

asc[0]:= chr(255);
len:= slen(asc);
writeln(' with string 0..80, len byte = 255, len = ',len:1);
writeln('  (should be warning and len = 0)');
writeln;

asc3[0]:= chr(189);
len:= slen(asc3);
writeln(' with string 0..500, len = ',len:1);
writeln('  (should be len = 189)');
writeln;

for i:= 5 to 35 do asc2[i]:= chr(68);
len:= slen(asc2);
writeln(' with string 5..35, len = ',len:1);
writeln('  (should be warning and len = 0)');
writeln;

writeln('end of SLEN test');
writeln;

end.
