Program TstQIO;

{ Version
  File:[22,311]TSTQIO.PAS
  Author: Philip Hannay  24-Aug-87
  History: 


Testing P3UTIL module(s):  QIO
Prerequisite module(s):  RDXF

}

{$nolist}
{[a+,b+,l-,k+,r+] Pasmat }
%INCLUDE EX:[22,320]GENERAL3.TYP;
%INCLUDE EX:[22,320]QIO.TYP;

%INCLUDE EX:[22,320]QIO.EXT;
%INCLUDE EX:[22,320]RDXF.EXT;

{$list}

{ To allow us maximum testing flexibility, we set up data structures as arrays
  that are tied to the event flag number, which can be 1-96.  We ignore the
  fact that this is a waste of space since this is a test program.
}

Var
  holdi, ids, i, j, lunnum, bufsiz, timeout: integer;
  iefn, efnnum: Event_flag;
  flags: event_flag_set;
  code, ifunc: qio_type;
  func: array [1..96] of qio_type;
  iostat: array [1..96] of IO_status_block;
  buf: array [1..96] of ch60;
  bufadr: address;
  done: boolean;

BEGIN
done:= false;
writeln('Begin QIO test');
repeat
writeln;
writeln('Function codes available are:');
writeln('  0 = attach');
writeln('  1 = detach');
writeln('  2 = kill');
writeln('  3 = read logical block');
writeln('  4 = read logical block with no echo');
writeln('  5 = write logical block');
writeln;
write('Enter Function code selection (0-5)> ');
if not(eoln(input)) 
  then begin
    readln(i);
    code:= kill;
    for ifunc:= attach to write_lb do if ord(ifunc)=i then code:= ifunc;
    write('Enter LUN number> ');
    readln(lunnum);
    write('Enter event flag number (same number used to examine IOSB, BUF)> ');
    readln(i);
    efnnum:= f0;
    holdi:= i;
    func[holdi]:= code;
    for iefn:= f0 to f96 do if ord(iefn)=i then efnnum:= iefn;
    if func[holdi] = write_lb
      then begin
        writeln('Enter output line (up to 60 chars): ');
        writeln('0        1         2         3         4         5         6');
        writeln('123456789012345678901234567890123456789012345678901234567890');
        readln(buf[holdi]);
        bufadr:= LOOPHOLE(Address,Ref(buf[holdi]));
        write('Enter output line size> ');
        readln(bufsiz);
        end;
    if func[holdi] in [read_lb, read_noecho]
      then begin
        for i:=1 to 60 do buf[holdi,i]:=' ';
        repeat
          write('Enter input buffer size (up to 60)> ');
          readln(bufsiz);
        until (bufsiz >= 0) and (bufsiz <= 60);
        bufadr:= LOOPHOLE(Address,Ref(buf[holdi]));
        end;
    if func[holdi] in [read_lb, read_noecho, write_lb]
      then begin
        if func[holdi] = write_lb
          then write('Enter VFC value (0 or negative for none)')
          else write('Enter timeout value (negative = no timeout)> ');
        readln(timeout);
        end;
    {done with parameter entry, lets call procedure}
    writeln;
    writeln('Calling QIO procedure....');
    QIO(func[holdi],lunnum,efnnum,bufadr,bufsiz,timeout,iostat[holdi]);
    ids:= $DSW;
    writeln;
    writeln('Returned from QIO procedure');
    writeln;
    writeln('ids=',ids:1);
    end
  else begin
    if eof(input)
      then begin
        done:= true
        end
      else begin
        writeln;
        write('Check status of QIO - enter flag # or 0 to exit> ');
        readln;
        readln(holdi);
        if holdi = 0
          then begin
            done:= true;
            end
          else begin
            efnnum:= f0;
            for iefn:= f0 to f96 do if ord(iefn)=holdi then efnnum:= iefn;
            RDXF(flags);
            ids:= $DSW;
            if ids < 0 
              then begin
                writeln('RDXF failed, DSW = ',ids:1);
                end
              else begin
                if efnnum in flags
                  then writeln('Flag ',holdi:1,' is set')
                  else writeln('Flag ',holdi:1,' is clear');
                end;
            if func[holdi] in [read_lb, read_noecho]
              then writeln('Input chars="',buf[holdi],'"');
            i:=iostat[holdi,1] div 256; {high byte}
            j:=iostat[holdi,1] mod 256; {low byte}
            writeln('iostat[holdi,1]=',iostat[holdi,1]:1,'  low byte=',
               j:1,' high byte=',i:1);
            writeln('iostat[holdi,2]=',iostat[holdi,2]:1);
            end;
        end;
    end;
until done;
writeln;
writeln('end of test.');
writeln;
end.

