PROGRAM UCDATE;
{$nomain}
{$nowalkback}

{ File: [22,310]UCDATE.PAS       
  Author:   9-Jun-87.  Bob Thomas.

  Last Edit: 23-JUN-1988 22:38:31 
  
  History:
	 23-JUN-1988 22:00:08  - JMB PA3UTL upgrade.

}


%include PAS$EXT:General.typ;
%include PAS$EXT:sassign.ext;


Procedure UCDATE(var In_date:PACKED ARRAY[LOin..HIin:integer]OF char;
		   { 7 char date  DDMMMYY}
		 var Out_date:PACKED ARRAY[LOout..HIout:integer]OF char
		   { 9 char DEC style date DD-MMM-YY }
                ); external;


{*USER*

.hl 2 UCDATE - Uncompress date

The UCDATE routine will convert a 7 character date string (DDMMMYY) into 
a DEC format ascii date (DD-MMM-YY) by adding the hyphens. The 7 character 
Ascii date is often encountered in FMS data handling.

The input string can be any string type - only the first 7 characters are used.
They are moved, with the hyphens added, to the first 9 characters of the 
output string, which can also be of any type.
}

{*TECH*

This routine makes no validity checks of the incoming string and will ,in 
fact, inserting a new 3rd and 7th characters to any CH7 string returning a CH9
string. It will work with any type zero or type one strings as long as the 
effective string lengths are 7 chars for input and 9 chars for output.

}

PROCEDURE UCDATE;

Var
 temp_date:ch9;
 i: integer;

Begin

  For i:=1 to 2 do Temp_date[i]:=In_date[i];
  Temp_date[3]:='-';
  For i:=4 to 6 do Temp_date[i]:=In_date[i-1];
  Temp_date[7]:='-';
  For i:=8 to 9 do Temp_date[i]:=In_date[i-2];
  sassign(Out_date,Temp_date);
End;

