Program SInsert;

{$nowalkback}
{$NOMAIN [A+,B+,L-,K+] }

{ 
  Version: 3.2
  File: [22,310]SINSERT.PAS
  Author: Jim Bostwick 31-Aug-83

  Last Edit: 23-JUN-1988 22:26:10 

  History: 
	 23-JUN-1988 21:58:51  - JMB PA3UTL upgrade.
 	 18-Oct-84 JMB -- fix subscript bounds error
  	 23-Nov-83 JMB -- convert back to null fill
	 21-Nov-83 JMB -- convert to blank fill 


  	** NOTE **
 Part of this software is copyright OMSI. Source Distribution to 
licensed OMSI Pascal sites only.
}

%INCLUDE PAS$EXT:ABORT.EXT;
%INCLUDE 'PAS$EXT:slen.ext';

procedure SInsert(var t: packed array [tlow..thigh: integer] of char;
                 s: packed array [slow..shigh: integer] of char;
                 Start: integer
  	);External;

{*USER*
 Insert string "s" into string "t", starting at position "start". Characters
of t are moved to the right of as needed. The combination of "S" and "T"
may be larger than the size of "t", in which case "t" will be truncated
- including part of "s", if this is required.
Values of Start which would produce a non-contiguous string result in 
a fatal error. 
}


Procedure Sinsert;

  var
    i, j, tl, sl: integer;


  begin {insert}
      tl := slen(t);
      sl := slen(s);
      if sl > 0 then
        if (Start > 0) and (Start <= tl) then
          begin
          tl := sl + tl;
  	  if tl > thigh then {we truncate part of t, at least}
	    tl := thigh;
	  j := tl;
	  if Start + sl <=   tl then { we keep some of t }
	    while j >= start + sl do 
	      begin
	      t[j]  := t[j - sl];
	      j := j - 1
	      END;
	  for i := start to j do
	    t[i] := s[i-start+1];	{ stuff all or part of s in }
          if tlow = 0 then t[0] := chr(tl);
          end
  end {SInsert} ;

