Program SDelete;

{ Version: 3.2
  File:[22,310]SDELETE.PAS;
  Author: Jim Bostwick - 29-Aug-83

  Last Edit:  23-JUN-1988 22:25:28 

  History: 
	 23-JUN-1988 21:58:40  - JMB PA3UTL upgrade.
  	 23-Nov-83 JMB -- back to null fill, implement left-delete
	 21-Nov-83 JMB -- convert to blank fill

Part of the Pascal-3 String Package.

  	*** NOTE ***
Part of this software is copyrighted by OMSI. Distribution of source
to lisenced OMSI Pascal sites only!
}
{$NOMAIN}
{[A+,B+,L-,K+,R+] Pasmat Directive }
{$nolist}
%INCLUDE 'PAS$EXT:SLen.ext';
{$list}

procedure Sdelete(var t: packed array [tlow..thigh: integer] of char;
                       start, span: integer
  	);External;

{*USER*
  	-- String Package Module -- 
 Delete the portion of string T. The first character deleted is T[start],
and span characters are deleted. If span is negative, characters to the 
left of Start are deleted; if positive, characters to the right of start.
If T is a Type "1" string, it is filled
to its size with trailing nulls. If T is a Type "0" string, garbage remains
beyond the new end of T. 
}

Procedure SDelete;

  var
    i, limit, Tl: integer;


  begin {SDelete}
    Tl := Slen(t);
    if span < 0 then
      begin
      span := - span;
      start := start - span
      end;
    limit := start + span;  { limit->first char to move }
    if start < 1 then start := 1;
    if limit <= Tl then 
      BEGIN 	{ crunch some chars down (to left) }
      span := Tl - limit; { length of remainder of string }
      for i := 0 to span do t[start + i] := t[limit + i]; { crunch string }    
      start := start + span  { set start of deletion }
      END;
    if tlow = 0 then t[0] := chr(start)  { set new end }
      else for i := start to Tl do t[i] := chr(0)
  end; {SDelete} 

