Program SAssign;

{ String Package Module

  Version: 3.2
  File:[22,310]SASSIGN.PAS
  Author: Jim Bostwick 30-Aug-83

  Last Edit:  23-JUN-1988 22:22:46 

  History:
	 23-JUN-1988 21:58:17  - JMB PA3UTL upgrade.
	 21-Nov-83 JMB -- change to blank fill 
         23-Nov-83 PTH -- back to null fill, included SLEN call

        *** NOTE ***
  Part of this software is copyrighted by OMSI. Source distribution
to lisenced OMSI sites only.
}
 {$NOMAIN}
 {[A+,B+,K+,L-] Pasmat Directive }

%include PAS$EXT:slen.ext;

  procedure SAssign(var T: packed array [Tlow..Thigh: Integer] of Char;
                    S: packed array [Slow..Shigh: Integer] of Char);
    external;

{*USER*
        -- String Package Module --
 Assign string "S" to string "T". If SLn(S) > SLn(T), S is truncated
to the length of T. If T is greater, and T is a Type "1" string, T is
padded with nulls. 
.NOTE
 If the source string "S" is a Type "1" string, its length is determined
by the rightmost non-null character. 
.end note
}


  procedure SChAssign(var T: packed array [Tlow..Thigh: Integer] of Char;
                      c: Char);
    external;

{*USER*
        -- String Package Module --
Assign character "c" to string "T". If T is Type "0", its length is set to 
1, else T is right padded with nulls.
}


  procedure SAssign;

    var
      SLn: Integer;
      I: Integer;


    begin {SAssign}
      if Slow = 0 then SLn := ord(S[0]) else SLn := Slen (S);
      if SLn > Thigh then SLn := Thigh; {Truncate S to size of T}
      for I := 1 to SLn do T[I] := S[I];
      if Tlow = 0 then T[0] := Chr(SLn)
      else if (Tlow = 1) and (SLn < Thigh) then
        for I := SLn + 1 to Thigh do T[I] := chr(0);
    end {SAssign} ;


  procedure SChAssign;

    var
      I: Integer;


    begin {SChAssign}
      T[1] := c;
      if Tlow = 0 then T[0] := Chr(1)
      else for I := 2 to Thigh do T[I] := chr(0)
    end {SChAssign} ;
