; File: [22,310]P3UTIL.CMD      Last Edit: 18-SEP-1989 16:03:23 
;
; This command file will rebuild the P3UTIL distribution from scratch.
; We will operate in NAMED mode, with DEF set to [22,310].  Your 
; UIC should be set to a priv account.  We assume DCL.
;
; IMPORTANT - MAKE SURE THE COMPILER PA3 AND MACRO FILE PASMAC on
; LB:[3,54] AND LB:[22,310] ARE CURRENT BEFORE STARTING.
;
.ASK RESP READY TO GO ON
.IFF RESP .STOP
;
; You may choose to skip the creation of the EXT files.  This is the
; case if we have already done them, and are having trouble with the
; library build, and thus are re-running this command file.
;
.ask doext Do you want to create the EXT files

.enable substitution

; See if we are running in DCL
;
.if <cli> eq "DCL" .goto cliok
;
; You must be set to DCL to run this command file.
;
.stop

.cliok:
;
; we are running DCL - set up environment
;
set def /named
.if <exstat> ne 1 .goto badend
set def [22,310]
.if <exstat> ne 1 .goto badend
;
; Logical PAS$EXT points the external and include files device.
; Normally, this is the system disk.  However, in this case it will
; be locally assigned to this work disk, so that we are assured of
; using the latest files.  This will also keep us from messing with
; the files on the system disk until we are sure it all works.
;
def pas$ext sy:[22,320]
;
; Delete old log and xlg files
pip p3util.log;*,.xlg;*/de/nm
;
; Build the EXT extraction program.
pa3 p3ext/list
.if <exstat> ne 1 .goto badend
tkb @p3ext.tkb
.if <exstat> ne 1 .goto badend
pip p3ext.obj;*,.lst;*,.map;*/de
pip p3ext.*/pu

.iff doext .goto noext
; Create EXT external include files.  Note that existing LB: P3EXT.TSK
; will be used to create externals.  If you have trouble, copy the
; newly rebuilt P3EXT.TSK from sy:[22,310] to lb:[22,310]
@buildext p3util
.if <exstat> ne 1 .goto badend

.noext:
; Delete old P3UTIL library and create new empty one.
pip p3util.olb;*/de
.if <exstat> ne 1 .goto badend
lbr p3util.olb/cr:150.:200.:100.:obj
.if <exstat> ne 1 .goto badend

; Populate P3UTIL library.
@buildlbr p3util
.if <exstat> ne 1 .goto badend

; Truncate library to shortest length
pip p3util.olb;*/tr

;
; no errors encountered during P3UTIL.CMD - check LOG and XLG files to
; be sure.
; 
.goto end

.badend:
;
; error during P3UTIL.CMD execution - aborted 
;

.end:
;
; clear out local pas$ext logical
deass pas$ext
;
;
