PROGRAM cintas;

{
  File:[22,310]cintas.PAS
  Author: Jim Bostwick 18-Oct-83  

  Last Edit: 10-SEP-1989 11:16:51 

  History:
	 23-JUN-1988 21:56:04  - JMB PA3UTL upgrade.
          7-Sep-89.  Philip Hannay.  Updated for use with type0/type1 strings.

}

{$nomain}
{$NOLIST}
{[A+,B+,L-,K+,R+] Pasmat directive }

%INCLUDE PAS$EXT:General.typ;
%include pas$ext:sclear.ext;
%include pas$ext:schconcat.ext;
%include pas$ext:sconcat.ext;


 {$LIST}

{-------------- Convert Integer to Ascii -----------------------------}

 PROCEDURE cintas(Bin:Integer;
		Var asc:Packed array [lo..Hi:Integer] of char;
  	    	Pos:integer
	);external;

{*USER*

.hl 2 CINTAS - Convert Integer to Ascii

PASCAL-3 procedure to convert 16-bit, signed integer in BIN to an ASCII
string ASC, using decimal radix.  The placement of the ascii number in
ASC will be controlled by the value of POS.  The string ASC must be
a type0 or type1 string.

POS controls position, fill, and justification of output string.
If POS > 0, then the ascii number will be left-justified, starting at POS.
If POS = 0, then the ascii number will be right-justified filling the whole
string.  If POS < 0, the the ascii number will be right-justified, ending
at position POS.

A minus sign "-" will be placed in front of the number if the integer is
a negative value.  When padding is required, blanks will be used.  The
string value will be "assigned", and so any previous value in the string
ASC will be overwritten.

The maximum possible string length requirement is 6 characters (-32767).
If the string supplied cannot hold the ascii number (based on POS),
it will be cleared (returned with zero length).  The caller may detect 
the zero length and determine what action to do (such as display asterisks
or the like).

}

procedure cintas;

VAR
  i: integer;       { general subscript and counter }
  num: integer;     { hold number to convert }
  anum: ch6;        { holds converted number }
  index: integer;   { pointer into ANUM }
  first: boolean;   { set TRUE if suppressing zeros }
  alen: integer;    { length of converted number plus minus sign if any }
  npad: integer;    { number of blank pads needed before number }
  dig: integer;     { units digit }
  factor: integer;  { units divider }
  foo: boolean;     { set true if error }

BEGIN    { cintas }
foo := false;  { no error yet }
{ convert integer to ascii - hold in ANUM, left justified }
index:= 1;
if bin < 0
  then BEGIN 
    { negative integer, put in minus sign }
    num:= -(bin);
    anum[index] := '-';
    index := index + 1
    END
  else begin
    num := bin; 
    end;
{ max integer is 32767 }
factor:= 10000;
first:= true;
repeat
  { Convert integer to ascii digits, starting at high order digit.  Suppress
    leading zeros. }
  dig:= num div factor;
  if not((first) and (dig = 0))
    then begin
      anum[index]:= chr(ord('0')+dig);
      index:= index + 1;
      first:= false;
      end;
  num:= num mod factor;
  factor:= factor div 10;
until factor = 0;
if index = 1
  then begin
    { no digits, value was 0, put in a single zero }
    anum[index]:= '0';
    index:= index + 1;
    end;
{ Ascii number is now in ANUM.  Fill any remaining characters in ANUM with
  nulls to make ANUM a type1 string.  Store length of number in ALEN. }
for i:= index to 6 do anum[i]:= chr(0);
alen:= index - 1;

{ See if we have enough room for ascii number - if not, set FOO = TRUE.
  Also determine how many preceding blank pads are needed, put in NPAD. }
if (pos = 0) 
  then begin
    { right justify, using entire string }
    if (hi < alen) then foo:= true else npad:= hi - alen;
    end
  else begin
    if (pos > 0) 
      then begin
        { left justify, starting at POS }
        if hi < (alen + pos - 1)
          then foo:= true else npad:= pos - 1;
        end
      else begin
        { pos < 0 -- right justify, ending at POS }
        if (hi < alen) or (hi < -(pos)) or (-(pos) < alen)
          then foo:= true else npad:= -(pos + alen);
        end;
    end;

sclear(asc);
if not(foo)
  then begin
    { put in padding and number }
    for i:= 1 to npad do schconcat(asc,' ');
    sconcat(asc,anum);
    end;

end;  { procedure CINTAS }

