{$NOLIST}

{GENERAL PACKED DECIMAL TYPES
 These types define a general PACKED DECIMAL type.  The PACKED DECIMAL
 character set ranges from '0' (30 hex) thru '9' (39 hex) 
 and '*' (2A hex) thru '/' (2F hex).  These characters pack into 4 bits.

 Packed decimal arrays are always of even length (digits).  Remember that
 when dealing with packed decimal, the digit are store 2 per byte, and
 the low order digit of a pair includes the low order byte of the byte
 which means it has a lower array subscipt number than the high order 
 digit of the pair.  Thus if you store the number 3769 is a 4 element
 array PK with two bytes, PK[1] will be 7, PK[2] will be 3, PK[3] will
 be 9, AND PK[4] will be 6.

 Furthermore, if you want compatibility with Datatrieve, you must
 package the number with a leading 0 hex and a trailing F hex.  So
 for the number 3769, DTR would create a 6 element array PKDTR (3 bytes)
 containing 03769F, and so PKDTR[1] = 3, PKDTR[2] = 0, PKDTR[3]=6,
 PKDTR[4]=7, PKDTR[5]=F, and PKDTR[6]=9.

 In a packed decimal array, the high order digit is in array[1].

File: [22,320]PACKED.TYP    Last edit: 22-APR-1988 08:57:26 

History:  Philip Hannay.  21-Apr-88.  Created.

}

TYPE
  Packed_decimal = 0..15; {4 bits when used in packed structure}

  PK2 = packed array [1..2] of Packed_decimal;
  PK4 = packed array [1..4] of Packed_decimal;
  PK6 = packed array [1..6] of Packed_decimal;
  PK8 = packed array [1..8] of Packed_decimal;
  PK10 = packed array [1..10] of Packed_decimal;
  PK12 = packed array [1..12] of Packed_decimal;
  PK14 = packed array [1..14] of Packed_decimal;
  PK16 = packed array [1..16] of Packed_decimal;
  PK18 = packed array [1..18] of Packed_decimal;
  PK20 = packed array [1..20] of Packed_decimal;

{$LIST}
