{ File:  [22,320]MSGPACKET.TYP        Last edit: 8-AUG-1989 08:57:52 

  History:

     24-Jan-89.  Philip Hannay.  Created from Scale ([16,20]) version.
     14-Feb-89.  Philip Hannay.  Added PK_GATE_OPEN.
     05-Mar-89.  Philip Hannay.  Modified PK_CHECK_CONFIG.
     16-Mar-89.  Philip Hannay.  Added packet subtypes.  Major changes
                    to packet ids and record structure.
     24-Mar-89.  Philip Hannay.  Added PS_NO_INFO and PS_NOCANDO.
     04-Apr-89.  Bob Thomas.     Chgd Pk_null to Pk_misc, Made pk_comment
		    into [0..132], Chgd Pk_do_transaction to pk_send_as_is
     21-Apr-89   Bob Thomas.     Added priority field to bin_info.
     22-May-89.  Philip Hannay.  Added PK_FIELD_VALUE and field, added
                    RESOURCE_DETAIL field to PK_RESOURCE.
     06-Jun-89.  Philip Hannay.  Moved FIELD_STATUS field to new location
                    in PK_FIELD_VALUE.
     19-Jun-89.  Philip Hannay.  Added PK_RECORD packet, changed 
                    PK_CONTROL_SHORT to PK_CONTROL_ALPHA,
                    PK_CONTROL_LONG to PK_CONTROL_NUMERIC,
                    PK_TRANSACTION_ACKED to PK_ACKED_TRANSACTION,
                    and PK_TRANSACTION_NAKED to PK_NAKED_TRANSACTION.  Also
                    added comments about which strings are TYPE0
                    strings (byte count required).
     3-Aug-89.  Philip Hannay.  Changed meaning NUMERIC_LEN field of 
                    PK_CONTROL_NUMERIC from byte count to word count.
                    NUMERIC_LEN remains defined as a word.
                    Added FIELD_TERM field to PK_FIELD_VALUE.
     7-Aug-89.  Philip Hannay.  Changed some types to use CH200, STR193
                    and STR199 newly added defs to GENERAL.TYP.
     8-Aug-89.  Philip Hannay.  Added "SCALE_" prefix to PK_SCALE fields,
                    changed PK_RECORD length count to words from bytes.
                    

}
  
{ The following are message packet ids that can be used to identify
  a message packet contents. The first 40 packet types are defined
  as generic types so that they will map the same packets used on
  all AMI systems.  The packet types after that point (following pk_comment)
  will be site or system specific.  At this time, they will
  be unique for all locations.  At some future time, we may need to
  change MSGPACKET.TYP from a "general" to a "site specific" type
  file to allow for a wider variety of message packets.  At that future
  time we will still retain the first 40 packets as generic so that
  different systems can still communicate if they restrict themseleves
  to the first 40 packets. 

  The packet type "pk_unknown" will always be the last packet type on 
  all systems.  This lets us do an ord(pk_unknown) to find out packet range.}

{ It is assumed that PAS$EXT:GENERAL3.TYP and PAS$EXT:STRING.PKG
  precede the include file.  }

{ NOTE - old style packets begin with "@", that will translate into
  the 65th element of the packet id type.  If we ever need it, we
  will define it as such in a site specific packet.  }

Type

{ Message packet ids identify the general type of message packet.  
  The comments are from the sender's point of view }

  Message_packet_id_type = (
            { from here to pk_comment are AMI generic }

             pk_misc,                { misc message, always the first id }
             pk_debug,               { modify your debug mode }
             pk_monitor,             { modify your monitor mode }
             pk_view,                { modify your view (single step) mode }
             pk_info_short,          { short general info le 20 bytes }
             pk_info_long,           { long general info gt 20 bytes }
             pk_check_config,        { review your current configuration }
             pk_orderly_abort,       { you stop as soon as possible }
             pk_wake_up_sender,      { wake me up or notify me of events }
             pk_send_as_is,          { send this to a device verbatim}
             pk_ACKed_transaction,   { I sent transaction to device, it ACKed }
             pk_NAKed_transaction,   { I sent transaction to device, it NAKed }
             pk_resource,            { do something about a resource }
             pk_identity,            { general identity info }
             pk_gate,                { general gate info }
             pk_report_status,       { report your status }
             pk_synch,               { synchronize with eachother }
             pk_scale,               { general scale info }
             pk_control_symbol,      { control system symbol info }
             pk_control_alpha,       { control sys alpha value }
             pk_control_numeric,     { control sys numeric value(s) }
             pk_bin,                 { general bin info }
             pk_field_value,         { field name, value and status }
             pk_record,              { generic record field }
             pk_reserved9,
             pk_reserved10,
             pk_reserved11,
             pk_reserved12,
             pk_reserved13,
             pk_reserved14,
             pk_reserved15,
             pk_reserved16,
             pk_reserved17,
             pk_reserved18,
             pk_reserved19,
             pk_reserved20,
             pk_reserved21,
             pk_reserved22,
             pk_reserved23,

             pk_comment,              { general comment }

             { now the site/system specific packets }
  
             pk_phil,  { used in NSSO/NDT (NN) system }


             { and the trailer - always present, AMI generic }
             pk_unknown               { unrecognized, always last id }
            );
                     

{ Message paacket sub types further modify the message packet id.  The 
  comments are from the sender's point of view.  There is a maxium of
  32 elements that we can define in the set without changing the 
  message packet record length. }

  Message_packet_sub_type = (
                        ps_ack,       { you asked for ack, I got your packet }
                        ps_nak,       { you asked for ack, I don't do these }
                        ps_ack_requested,  { you ack this packet on receipt }
                        ps_req_info,  { you send me info }
                        ps_fill_info, { you fill in some/all info, return to me}
                        ps_no_info,   { I give you no info - couldn't find any}
                        ps_some_info, { I give you partial info }
                        ps_full_info, { I give you complete info }
                        ps_start,     { you start something at beginning}
                        ps_stop,      { you stop something in progress }
                        ps_resume,    { you continue on from stop }
                        ps_finish,    { you finish and end something }
                        ps_event,     { event occurred, I notify you }
                        ps_allocate,  { can I have it? }
                        ps_grant,     { I give it to you }
                        ps_deny,      { I cannot give it to you }
                        ps_execute,   { you execute something }
                        ps_open,      { you open a channel }
                        ps_get,       { you get something, send it to me }
                        ps_put,       { here is something, you put it away }
                        ps_close,     { you close a channel }
                        ps_watch,     { watch for change, let me know } 
                        ps_nocando,   { I cannot do what you asked }
                        ps_reserved3, { spare }
                        ps_reserved4, { spare }
                        ps_reserved5, { spare }
                        ps_reserved6, { spare }
                        ps_reserved7, { spare }
                        ps_reserved8, { spare }
                        ps_reserved9, { spare }
                        ps_reserved10,{ spare }
                        ps_reserved11 { spare }
                       );

  Message_packet_sub_set = packed set of message_packet_sub_type;




{ Message_packet_type is a variant record allowing easy access to the
  contents of a message packet.  In general we put the variable part
  of a message packet at the end of the record, allowing us to use
  byte/word count indicators to signal the actual length of the
  message for transmission purposes which can be used by the
  LENMSG routine in MSGPACKET.PAS to determine the actual message packet
  length (used).  The variant part of the record can be up to 200 
  bytes, and will be word aligned. }

Message_packet_type = record
                  id: message_packet_id_type;
                  sub: message_packet_sub_set;
                  case message_packet_id_type of

                    { from here to pk_comment are AMI generic }
                    pk_misc:
                      (value: ch200);

                    pk_debug:
                      (deb_level: char;   { 0 thru 9 }
                       deb_device: ch60);

                    pk_monitor:
                      (mon_level: char;   { 0 thru 9 }
                       mon_device: ch60);

                    pk_view:
                      (view_level: char;   { 0 thru 9 }
                       view_device: ch60);

                    pk_info_short:
                      (sinfo: ch20);

                    pk_info_long:
                      (linfo: str199);  {type0 string}

                    pk_check_config:
                      (config_file: ch60);

                    pk_orderly_abort:
                      ();

                    pk_wake_up_sender:
                      ();

                    pk_send_as_is: 
                      (content: str199); {type0 string}

                    pk_ACKed_transaction:         {ack from device}
                      (ACK_content: str199);  {type0}

                    pk_NAKed_transaction:         {nak from device}
                      (NAK_content: str199);  {type0}

                    pk_resource:
                      (resource_name: ch10;
                       resource_owner: ch10;
                       resource_detail: ch10);

                    pk_identity:
                      (ident: ch20);

                    pk_gate:
                      (gate_name: ch6;          { name }
                       gate_status: word;       { status bits }
                       gate_set: integer;       { requested opening }
                       gate_current: integer;   { current opening }
                       gate_max: integer;       { maximum open except shakeout }
                       gate_shake: integer);    { shakeout percent }

                    pk_report_status:
                      (device_stat: ch60);

                    pk_synch:
                      (synch_text: ch10;
                       synch_num: integer);

                    pk_scale:
                      (scale_order_type: char;  { R or S }
                       scale_header1: ch80;
                       scale_header2: ch80;
                       scale_product: ch4;
                       scale_order_size: ch8;
                       scale_draft_size: ch6;
                       scale_gate_open: ch2);

                    pk_control_symbol:
                      (symbol_type: word;        {word,float,...}
                       symbol_name: ch18;        {alpha name}
                       symbol_DB: word;          {database,station,node...}
                       symbol_offset: word);     {starting offset into database}

                    pk_control_alpha:
                      (alpha_type: word;         {ascii, asciz,...}
                       alpha_DB: word;           {database,station,node...}
                       alpha_offset: word;       {starting offset into database}
                       alpha_value: str193);     {value} {type0 string}

                    pk_control_numeric:
                      (numeric_type: word;       {word,float,...}
                       numeric_DB: word;         {database,station,node...}
                       numeric_offset: word;     {starting offset into database}
                       numeric_len: integer;     {word count of value(s)}
                       numeric_value: array [1..96] of integer);
                                                 {value(s)}
                    pk_bin:
                      (bin_name: ch6;       { name }
                       bin_status: word;    { status bits }
                       bin_level: integer;  { measured from bottom }
                       bin_height: integer; { max height measured from bottom }
                       bin_cgrade: ch6;     { grade code }
                       bin_grade: ch10;     { grade name }
                       bin_sgrade: ch10;    { subgrade name }
                       bin_priority: char); { bin priority }

                    pk_field_value:
                      (field_name: ch6;     { name }
                       field_status: word;  { free form status like attributes }
                       field_term: word;    { field terminator code }
                       field_value: str80);
                                     { value (contents) }  {type0 string}
                    pk_record:
                      (record_len: integer;  { record length in 2byte words }
                       record_value: array [1..99] of integer); { value }

                    pk_reserved9:
                      ();

                    pk_reserved10:
                      ();

                    pk_reserved11:
                      ();

                    pk_reserved12:
                      ();

                    pk_reserved13:
                      ();

                    pk_reserved14:
                      ();

                    pk_reserved15:
                      ();

                    pk_reserved16:
                      ();

                    pk_reserved17:
                      ();

                    pk_reserved18:
                      ();

                    pk_reserved19:
                      ();

                    pk_reserved20:
                      ();

                    pk_reserved21:
                      ();

                    pk_reserved22:
                      ();

                    pk_reserved23:
                      ();

                    pk_comment:
                      (comment: str199); {type0 string}

                    { now the site/system specific packets }

                    pk_phil:
                      (philnote: ch60);


                    { and the trailer - always present, AMI generic }
                    pk_unknown:
                      ();
                  end;  {record}


{ end of MSGPACKET.TYP }

