{$NOLIST}

  {GENERAL BCD TYPES
   These types define a general 4-digit BCD type. This is usefull for setpoints
   and so on. 

   FILE: [22,320]BCD.TYP  (WAS BCDTYP.PAS)

   History: jmb 22-FEB-82  Created
            Phil Hannay  19-Oct-83  changed name to BCD.TYP to conform to
             our new naming standards.
            Philip Hannay.  9-Aug-89.  Changed BCD_DIGIT to 0..15 from 
             0..10.  Why it was 10 and not 9, who knows.  Anyway,
             this avoids rangecheck problems when we get BCD digits
             from instruments that are not valid BCD digits.  We validate
             the digits using (digit in [0..9]) or CBCTAS routine.

}

TYPE
  BCD_digit = 0..15; {4 bits when used in packed structure}
  BCD4 = PACKED array [1..4] of BCD_digit; 
  BCD4_Address = WORD; { pointer to BCD4}

{NOTES ON BCD:
 1. BCD is stored as follows: 
	The lo digit (1's) lives in BCD4[1], which is the 
		low 4 bits of the word.
	the hi digit (1000's) lives in BCD4[4], which is the
		hi 4 bits of the word.

}
{$LIST}
