{$DOUBLE}

Program TSTMSG;

{
  Description: Test routine for message routines
         File: [message]TSTMSG.PAS
       Author: Jim Bostwick 14-JUN-1988 
    Last Edit: 9-OCT-1989 22:13:03 
      History:
    	 9-OCT-1989 - JMB - major happy munging...
	 3-AUG-1989 - JMB - Add $DOUBLE compiler switch


Testing P3UTIL module(s): msinit, mssend, msrcv

}

{$nolist}
{[a+,b+,l-,k+,r+] Pasmat }
%INCLUDE 'PAS$EXT:GENERAL.TYP';
%INCLUDE 'pas$ext:msgpacket.pkg';
%INCLUDE 'PAS$EXT:MESSAGE.pkg';
%INCLUDE 'PAS$EXT:STRING.PKG';
%INCLUDE 'PAS$EXT:CATR56.EXT';
%INCLUDE 'PAS$EXT:CR56TA.EXT';
{$list}

var
	hdr: Message_header_rec;
	out_msg,In_Msg: Message_rec;
	Stat: integer;
	r5nam:Rad56;

{ Procedure to dump DSW and header }
Procedure Dump_hdr(Var h:Message_header_Rec);

VAR
	nam: CH6;
BEGIN
	writeln('And the status is ',$DSW);
	write('Dest_node is ',h.dest_node,', ');
	cr56ta(h.dest_task,nam);
	writeln('Dest_task is ',nam,' .');
	write( 'Src_node is ',h.src_node,',');
	cr56ta(h.src_task,nam);
	writeln( 'Src_task is ',nam);
	cr56ta(h.router,nam);
	writeln( 'router is ', nam);
        writeln( 'Router_node is ',h.router_node);
	writeln( 'User_flags = ',loophole(word,h.user_flags):-6,', ',
		'User_protocol = ',h.user_protocol:-6);
	writeln( 'Text_size =', h.text_size);
	writeln
end;



begin
	writeln('Testing messages. ');
	Writeln('Msinit...');
	out_msg.body.id := pk_comment;
	out_msg.body.sub := [];
	SAssign(Out_msg.body.comment,'This is a test message.');	
{ 
    NOTE: To test fixed message size, use first line below. To test
    auto_size, use second. Comment out one or the other. 
}
{---	msinit('DAN   ','TSTMSG',80,Out_Msg,stat); }

	msinit('DAN   ','TSTMSG',0,Out_Msg,stat);	
    
	writeln('And the status is ',stat);
	Dump_hdr(Out_Msg.hdr);
	Writeln('Sending it...');
	MSSend(Out_msg,f0);
	Writeln('and the status is ',$dsw:-6);
	Writeln('Try to get it back...');
	MSRcv(null_task_name,In_Msg);
	Dump_Hdr(In_Msg.hdr);
	Writeln('and the text is:');
	SWrite(Output,In_msg.body.comment);
	writeln;
	writeln('Now, do other message(s) without re-initializing headers...');
	SAssign(Out_msg.body.comment,'This is the second test message.');	
	MSSend(out_msg, f0);
	Writeln('and the status is ',$dsw:-6);
	SAssign(Out_msg.body.comment,'This is the third test message.');	
	MSSend(Out_msg, f0);
	Writeln('and the status is ',$dsw:-6);
	Writeln('Try receiving from task FOOBAR (which ain''t there).');
	Catr56('FOOBAR',r5nam);
	MSRcv(r5nam,In_msg);
	Dump_Hdr(In_msg.hdr);
	Writeln('and the text is...');
	SWrite(Output,In_msg.body.comment);
	writeln;
	Writeln('That should have failed.');
	Writeln('Try to get #2 and #3 back...');
	MSRcv(null_task_name,In_msg);
	Dump_Hdr(In_Msg.hdr);
	Writeln('and the text is:');
	SWrite(Output,In_msg.body.comment);
	Writeln;
	MSRcv(null_task_name,In_msg);
	Dump_Hdr(In_Msg.hdr);
	Writeln('and the text is:');
	SWrite(Output,In_msg.body.comment);
	writeln;
	
	writeln( 'done.')
end.
    
 
