
{ 
  Version: 1.0
  File:[22,320]NET.TYP
  Author: Jim Bostwick 
  Last Edit: 3-NOV-1988 19:28:33 

  History:
	 3-NOV-1988 18:19:47 - JMB - Redefine Records for DECNET
		M+ V4.1 (long connect blocks exclusively ).
	 17-SEP-1988 13:46:16 - JMB - Fully Define Connect Blocks
		as pascal record types. 
  
  This file contains DECnet definitions for OMSI Pascal-2.

}
{[a+,b+,l-,k+,r+] Pasmat }

{*USER*
There are two 'connect blocks' used by DECnet. The 
Net_request_block is used with outbound connections (e.g. calling
task initiates the link).  The Net_Connect_block is used for
inbound connections (e.g. calling program accepts the link). 
 Although DECnet-M-PLUS V4.1 supports both 'long' and 'short'
connect blocks, PASUTL only uses the 'long' form. 
}


CONST
    Net_Reqb_len = 76;  { Connect request block used with NTCON = 152. bytes }
    Net_Conb_len = 97;  { Connect block used with NTGND = 194. bytes }

TYPE 

{
    Subrecords for Network control blocks. 
}				

    Net_Destination_Descriptor = RECORD
	{ 
	 This record describes the destination task. The destination
	 task is the remote task for Request blocks, the local task
	 for Connect blocks.
	 }
	Dest_Format	: Byte;		{ 0 or 1 }
	Dest_Object	: Byte; 	{ 0 - 255 network object number }
		
	{
	  The next two fields are only used with Dest_Object = 0, and
	  Dest_Format = 1. That is, when requesting a task by name rather
 	  than network object number. 
	 }
	Dest_Task_len	: Integer; 	{ 0 - 16. length of dest task name }
	Dest_Task	: CH16;		{ ASCII Destination task name }
	END; { Net_Destination_Descriptor }
	

    Net_Source_Descriptor = RECORD
	{ This record is used in Connect blocks to describe the source
	  (remote) task. 
	 }
	Src_Node	: CH6;		{ WITH TRAILING BLANKS !!! }
	Src_Format 	: Byte; 	{ 0 or 1 descriptor format }
	Src_Object	: Byte; 	{ 0 - 255. Source object number }
	{
	  The next two fields are only used with Src_Object = 0, and
	  that is, when source task is not a known network object.
	 }
	Src_Task_len	: Integer; 	{ 0 - 16. length of Source task name }
	Src_Task	: CH16;		{ ASCII Source task name }
	END; 	{ Net_Source_Descriptor }
	
    Net_Access_Descriptor = RECORD
	{ This record contains access control information for the 
	  initiator of the link request. Initiator is local for Request
	  blocks, remote for Connect blocks. Note that CH40 fields are
	  used, even though 39. characters is the maximum allowed. This
	  maintains record alignment. 
	 }
	User_ID_len	: Integer;	{ 0 - 39. Length of user id }
	User_ID		: CH40;		{ User name }
	User_Pass_len	: Integer;	{ 0 - 39. Length of password }
	User_Pass	: CH40;	 	{ User password }
	User_Account_len: Integer;	{ 0 - 39. Length of Account }
	User_Account	: CH40; 
	END; 	{ Net_Access_Descriptor }

{
    Records for the two Network Control Blocks. 
 }

    Net_Request_block = RECORD
	{ 
	  Request block is used by initiator of link request. 
	  Must be initialized by NTCONB before use, and used 
	  in NTCON connect call. 
	 }
                                                                               
        Node_name 	: CH6;		{ ASCII WITH TRAILING BLANKS }
	Dest_Desc	: Net_Destination_Descriptor;
	Acc_Ctl		: Net_Access_Descriptor;
	END; 	{ Net_Request_block }

    Net_Connect_block = RECORD
	{ 
	  Connect block is used by receiver of link request. 
	  Returned by NTGND call, and used in NTACC. 
	 }
	Link		: Address; 	{ DON'T MODIFY }
	Seg_size	: Integer;	{ NSP Segment size }
	Dest_Desc	: Net_Destination_Descriptor;
	Src_Desc	: Net_Source_Descriptor; 
	Acc_Ctl		: Net_Access_Descriptor;
	Dat_Len		: Integer; 	{ Optional data length }
	Dat		: CH16;		{ Optional data }
	END; 	{ Net_Connect_Block }


{ DECnet IOSB codes. 

 These constants have been extracted from macro NSSYM$ in NETLIB.MLB.
They define various error and status codes. 

Names have been constructed as follows:
	1. Prefix all with "Nt_".
	2. Convert embedded "." in MACRO symbol name to "_".

	Example:	VS.NPV --> Nt_VS_NPV	(verified, non-priv user)

}

CONST
	{ Network Object Numbers }
Nt_NO_TAS = 0B;	{ General task, user process }
Nt_NO_FA1 = 1B;	{ File Access Listener (V1) }
Nt_NO_TC1 = 5B;	{ Task Control Listener (V1) }
Nt_NO_TCL = 17B;	{ Task Control Listener }
Nt_NO_TLK = 20B;	{ TALK utility }
Nt_NO_FAL = 21B;	{ File Access Listener }
Nt_NO_RTL = 22B;	{ Remote task loader }
Nt_NO_NCU = 23B;	{ Network control utility executor }
Nt_NO_DTR = 77B;	{ DECnet test receiver }

Nt_NT_LCB = 1B;	{ Long connect block } 

	{ Network Event Codes }
Nt_NT_CON = 1B;	{ Connect }
Nt_NT_INT = 2B;	{ Interrupt message }
Nt_NT_DSC = 3B;	{ User synchronous disconnect }
Nt_NT_ABT = 4B;	{ User abort }
Nt_NT_ABO = 5B;	{ Network abort }
Nt_NT_EVT = 6B;	{ Network event }
Nt_NT_VFY = 7B;	{ Network verification event }
Nt_NT_MOP = 10B;	{ MOP event }
Nt_NT_NSP = 10B;	{ NSP event (CCB only). same as NT.MOP }

	{ Verification Status }
Nt_VS_NPV = 1B;	{ Verified, non-privileged user }
Nt_VS_PRV = 2B;	{ Verified, privileged user }
Nt_VZ_NVD = 0B;	{ No verification performed }
Nt_VE_FAI = -1; 	{ Verification failed }

{
	Phase III Session Control error reason codes returned
	with REJECT (REJ) or DISCONNECT (DSC)
}
Nt_NE$RES = 1;		{ Resource allocation failure (REJ) }
Nt_NE$NOD = 2;		{ Destination node name does not map to a 
			    node address (rej) }
Nt_NE$NSR = 3;		{ Remote node shutting down (REJ) }
Nt_NE$UOB = 4;		{ Destination process does not exist (REJ) }
Nt_NE$FMT = 5;		{ Invalid format for object specification (REJ) }
Nt_NE$MLB = 6;		{ Mailbox full for queuing message to object
	 		    or too many connects to object (REJ) }
Nt_NE$ABM = 8;	 	{ Link aborted by management (DSC) }
Nt_NE$NNF = 10;	{ Node name format error (REJ) }
Nt_NE$NSL = 11;	{ Local node shutting down (REJ) }
Nt_NE$ACC = 34;	{ Access not permitted - unacceptable 
				 RQSTRID / PASSWORD ETC.(REJ) }
Nt_NE$ABO = 38; 	{ No response from object (REJ/DSC) }
Nt_NE$COM = 39;	{ Unable to communicate with node (REJ/DSC) }

	{ Standard RSX Error Codes }
{ 
	These error codes are standard RSX IOERR$ codes, with special
	meaning for DECnet. 
}
Nt_IS_SUC = 1;		{ Success }
Nt_IS_DAO = 2;		{ Success, but some data lost. }
Nt_IE_BAD = -1;	{ invalid buffer parameter, or data length > 16. }
Nt_IE_SPC = -6;	{ Invalid buffer parameters, buffer not word-aligned,
				illegal address space, buffer > 8128. words }
Nt_IE_WLK = -12;	{ Transmission of interrupt message before last one
				completed }
Nt_IE_DAO = -13;	{ Data overrun; unstored data was lost. }
Nt_IE_ABO = -15;	{ Link aborted or disconnected }
Nt_IE_PRI = -16;	{ Net not accessed on this LUN }
Nt_IE_RSU = -17;	{ Required system resources not available }
Nt_IE_ALN = -34;	{ Specified LUN already established. }
Nt_IE_NLN = -37;	{ No active link on Specified LUN }
Nt_IE_URJ = -73;	{ Remote task rejected connect attempt }
Nt_IE_NRJ = -74;	{ Network rejected connect attempt }
Nt_IE_NDA = -78;	{ There is no data available }
Nt_IE_NNT = -94;	{ The issuing task not a network tas; NTOPN not
			  executed successfully }
