{$DOUBLE}
{$NOWALKBACK$}
Program Struc;

{ 
  Version x1.0
  File:[decnet]STRUC.PAS
  Author: Jim Bostwick  17-SEP-1988 

  Last Edit: 3-NOV-1988 19:12:54 

  History:
;		 3-AUG-1989 10:50:29 - JMB - Add $DOUBLE switch

  Description:
	This program provides a check of the structure definitions
 	in DECNET.TYP.  The matchup of the Pascal record definitions
	for the connect blocks is critical to the correct function 
	of the PASUTL decnet routines. 
}
{$Nolist}
{[a+,b+,l-,k+,r+] Pasmat }
 %INCLUDE 'PAS$EXT:General.typ';
 %INCLUDE 'DECNET.TYP';
 %INCLUDE 'PAS$EXT:STRING.PKG';
{$List }


VAR
    CONB : Net_Connect_Block;
    REQB : Net_Request_Block;
    A 	 : Address; 
    Siz  : Integer;
    BSiz : Integer; 
    Base : Address; 


BEGIN
    Writeln('General Subrecord Sizes.');
    writeln('      Net_Destination_Descriptor:',
    	Size(Net_destination_Descriptor));
    writeln('      Net_Source_Descriptor:',
    	Size(Net_Source_Descriptor));
    Writeln('      Net_Access_Descriptor:',
    	Size(Net_Access_Descriptor));
    writeln;writeln;
    Writeln('Offsets for Net_Request_Block');
    Base := Loophole(Address, Ref(reqb));
    Writeln('      Base = ',Base:6,' Size = ',Size(Net_request_block),
          ' BitSize = ',Trunc(BitSize(Net_Request_block)/8));
    Writeln('      Dest_desc = ',
	 (loophole(address,ref(reqb.dest_desc))-base):6,
	 ' Size = ',Size(Net_Destination_Descriptor),
         ' BitSize = ',Trunc(BitSize(Net_Destination_descriptor)/8));
    Writeln('      Acc_Ctl = ', 
	 (loophole(address,ref(reqb.Acc_Ctl))-base):6,
	 ' Size = ',Size(Net_access_Descriptor),
         ' BitSize = ',Trunc(BitSize(Net_access_descriptor)/8));
    Writeln;

    Writeln('Offsets for Net_Connect_block');
    base := Loophole(Address, ref(conb));
    Writeln('      Base = ',Base:6,' Size = ',Size(Net_connect_block),
          ' BitSize = ',trunc(BitSize(Net_connect_block)/8));
    Writeln('      Seg_size = ', 
	(loophole(address,ref(conb.Seg_Size))-base):6);
    Writeln('      Dest_desc = ', 
	(loophole(address,ref(conb.dest_desc))-base):6);
    Writeln('      Src_Desc = ',  
	(loophole(address,ref(conb.Src_Desc))-base):6,
	'  Size = ',Size(Net_Source_Descriptor),
        ' BitSize = ',Trunc(BitSize(Net_Source_descriptor)/8));
    Writeln('      Acc_ctl = ',  
	(loophole(address,ref(conb.Acc_Ctl))-base):6);
    Writeln('      Dat_Len = ',  
	(loophole(address,ref(conb.Dat_len))-base):6);
    Writeln('      Dat = ',  
	(loophole(address,ref(conb.Dat))-base):6);

    Writeln
end.


