{$DOUBLE}
{$nowalkback}
Program NTDCB;
{$nomain}

{ 
  Version: x1.0
  File:[DECNET]NTDCB.PAS
  Author: Jim Bostwick  14-NOV-1988 

  Last Edit: 15-NOV-1988 01:18:28 

  Desc: Formatted dump of Net_Connect_block

  History: 
;		 3-AUG-1989 10:50:29 - JMB - Add $DOUBLE switch

	14-NOV-1988 JMB - created. 


}
{$Nolist}
{[a+,b+,l-,k+,r+] Pasmat }
 %INCLUDE 'PAS$EXT:General.typ';
 %INCLUDE 'Decnet.typ';

{$List }
{*CALL*}

Procedure  NtDCB(
		 C: Net_Connect_block
  	);External;

{*USER*

 Produce formatted dump of network connect (inbound) block. Primarily for
 debugging and development. Also serves as an example of connect block
 manipulation from Pascal. 

 }

{*WIZARD*

 }

Procedure NtDCB;



Procedure Dump_Destination_Desc(
	D: Net_Destination_Descriptor);

{ Formatted dump of the destination descriptor. }

BEGIN
    With D Do 
	BEGIN
	Writeln('Destination Descriptor:');
	Writeln('       Dest_Format   = ',Ord(Dest_Format):-3,'(8)');
	Writeln('       Dest_Object   = ',Ord(Dest_Object),'(10)');
	Writeln('       Dest_Task_len = ',Dest_Task_len,'(10)');
	Writeln('       Dest_Task     = ',Dest_Task:Dest_Task_len);
	Writeln
	END {with}
End; { dump_dest... }

Procedure Dump_Source_Desc(
    	S: Net_Source_Descriptor
    );

{ Formatted dump of Net_Source_Descriptor }

BEGIN
    With S DO
	BEGIN
	Writeln('Source Descriptor:');
	Writeln('       Source_Node      = ',Src_Node);
	Writeln('       Src_Format       = ',Ord(Src_Format),' (10)');
	Writeln('       Src_Object       = ',Ord(Src_Object),' (10)');
	Writeln('       Src_Task_len     = ',Src_Task_len,' (10)');
	Writeln('       Src_Task         = ',Src_Task:Src_Task_len);
	Writeln
	END {with}
End; { dump_source... }
	
Procedure Dump_Access_Desc(
	A: Net_Access_Descriptor
	); 
{ Formatted dump of access descriptor. }

BEGIN
    With A do
	BEGIN
	Writeln('Destination Descriptor:');
	Writeln('       User_ID_len      = ',User_ID_len,' (10)');
	Writeln('       User_ID          = ',User_ID:User_ID_Len);
	Writeln('       User_Pass_len    = ',User_pass_len,' (10)');
        Writeln('       User_Pass        = ',User_Pass:User_Pass_len);
	Writeln('       User_Account_len = ',User_Account_len,' (10)');
	Writeln('       User_Account     = ',User_account:User_Account_len);
	Writeln
	END {with}
End; { dump_access... }

BEGIN   { NTDCB }

    With C DO 
	BEGIN
	Writeln('Dump of Net_Connect_Block:');
	Writeln('       Link             = ', Loophole(word,link):-6,' (8)');
	Writeln('       Seg_size         = ', Seg_Size,' (10)');
	Dump_Destination_Desc(Dest_Desc);
	Dump_Source_Desc(Src_Desc);
	Dump_Access_Desc(Acc_Ctl);
	Writeln('       Dat_len          = ', Dat_Len,' (10)');
	Writeln('       Dat              = ', Dat:Dat_len);
	Writeln;
	Writeln('End of Net_Connect_Block.');
	Writeln
	END  {With}
END; {Dump...} 	

