{$nomain}
{$nowalkback}

{

File			: SC:[22,320]CCLTAS.PAS
Author			: Peter Stadick
Origin Date		: July 2,88
Edit History		:

	       Last Edit: 2-JUL-1988 13:20:14 

Description:
	The routine will convert a clunk value to given conforment array
	of char size. The routine will right justify the number in the
	array to specified number of decimal places and add a negitive sign
	if necessary. For example "   -1234.56", if you specfiied
	2 decimal places and negitive.

}
%include lb:[22,320]general3.typ;
%include de:[107,114]clunk.typ;
%include de:[107,114]cluc18.ext;

PROCEDURE ccltas(in_clunk	: clunk_type;
		 dec_places	: integer;
		 negitive	: boolean;
		 var asc	: PACKED ARRAY [lo..hi:INTEGER] OF CHAR);
 external;

PROCEDURE ccltas; 

CONST
  max_number_size = 18;

VAR
  asc_num	: ch18;
  i,j		: integer;

begin
  cluc18(in_clunk,asc_num);

  for i := lo to hi do
    asc[i] := ' ';

  { right justify }
  j := max_number_size;
  for i := hi downto lo do
  begin
    if j > 0 then
    begin
      asc[i] := asc_num[j];
      j := j - 1;
    end;
  end;

  { add decimal point }
  if (dec_places < (hi-lo) + 1) and (dec_places > 0) then
  begin
    for i := lo+1 to hi-dec_places do
      asc[i-1] := asc[i];
    asc[hi-dec_places] := '.';
  end;

  { remove leading zeros }
  j := lo-1;
  repeat
    j := j + 1;
    if asc[j] = '0' then asc[j] := ' ';
  until (j = hi) or ((asc[j] >= '0') and (asc[j] <= '9')) or (asc[j] = '.');

  { add negitive sign }
  if negitive then
  begin
    { Make sure we have space to add negitive sign }
    if (j < hi) or (j > lo) then
      asc[j-1] := '-';
  end;
end;
