Program tstspawn;

{ File: [22,311]TSTSPAWN.PAS      Last edit: 22-MAY-1989 17:16:56 

  History:

    22-May-89.  Philip Hannay.  Created.


  Test the P3UTIL SPAWN procedure.   Accepts a command line with
  the name of the task to spawn, and a command line to use, or will 
  prompt for that task name and command line.  Command line syntax
  is "xxxxxx ccccccccc...cccc" where xxxxxx is six task name (blank filled
  if need be) and cccc..ccc is variable length command line to give to
  the xxxxxx task when spawned.  A single space separates task name
  and command line.

}

{[A+,B+, K+, L-, R+] Pasmat Directive }

%include pas$ext:general.typ;
%include pas$ext:spawn.typ;

%include pas$ext:spawn.ext;
%include pas$ext:catr56.ext;  
%include pas$ext:stse.ext;

{ Use predefined pascal procedure GMCR to get MCR command line if any }
procedure GMCR;external;

{ Use predefined pascal procedure DETACH to detach TI: }
procedure DETACH;external;

Var
  task_name: ch6;
  rad_task_name: rad56;
  connect_block: spawn_status_array;
  dir_stat: integer;
  cmd_line: ch80;
  cmd_line_adr: word;
  i: integer;

Begin
GMCR;
readln(cmd_line);
Writeln;
Writeln('Test SPAWN procedure...');
Writeln;
if cmd_line[1] = ' '
  then begin
    Write('Enter name of task to spawn> ');
    Readln(task_name);
    Write('Enter command line if any> ');
    Readln(cmd_line);
    end
  else begin
    writeln;
    for i:= 1 to 6 do task_name[i]:= cmd_line[i];
    for i:= 8 to 80 do cmd_line[i-7]:= cmd_line[i];
    for i:= 74 to 80 do cmd_line[i]:= ' ';
    end;
detach;
catr56(task_name,rad_task_name);
writeln('  spawn task "',task_name,'"');
cmd_line_adr:= loophole(word,ref(cmd_line));
spawn(rad_task_name,f1,cmd_line_adr,80,connect_block);
dir_stat:= $dsw;
if dir_stat = 1
  then begin
    writeln('  spawn done successfully, wait for offspring task to exit');
    stse(f1);
    writeln('  offspring task exited, status is ', connect_block.exit_code:1);
    end
  else begin
    writeln('  unable to spawn task, $DSW = ',dir_stat:1);
    end;
writeln;
writeln('done with SPAWN test');
writeln;
end.
