Program Ssearch;
{$NOWALKBACK}
{$nomain}

{ 
  Version  3.2
  File:[22,310]Ssearch.PAS
  Author: Jim Bostwick 29-Nov-83

  Last Edit: 31-MAY-1989 15:42:24 

  History:
	 23-JUN-1988 21:59:19  - JMB PA3UTL upgrade.
         31-May-89.  Philip Hannay.  Fixed mixup of S and T parameters.

}
{$Nolist}
{[a+,b+,l-,k+,r+] Pasmat }
%INCLUDE 'PAS$EXT:slen.ext';
{$List }


function ssearch(t: packed array [tlow..thigh: integer] of char;
                s: packed array [slow..shigh: integer] of char;
                start: integer): integer;External;

{*USER*
 Ssearch returns the position within "t" of string "s". Zero is returned
if no match, else is the position of the first character of the search
string. Characters are compared to the length of "s". Parameter Start
defines the first character position of "t" to be examined. 
}

function ssearch;

  var
    i, j, tl, sl: integer;
    uneq: boolean;


  begin {search}
      ssearch := 0;  { assume no match found }
      sl := slen(s);
      tl := slen(t);  
      if (start + sl - 1 <= tl) and (sl <> 0) then
        begin
        i := start - 1;
        repeat
          i := i + 1;
          j := 0;
          repeat
            j := j + 1;
            uneq := s[j] <> t[i + j - 1];
          until uneq or (j = sl);
        until (not uneq) or (i = tl - sl + 1);
        if uneq then ssearch := 0 else ssearch := i;
        end;
  end {search} ;

